/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.util.sm3;

public class SM3 {
    public static final int DIGEST_LENGTH = 32;
    private static final int BLOCK_SIZE = 16;
    private int[] V = new int[8];
    private int[] inwords = new int[16];
    private int xOff;
    private final byte[] xBuf = new byte[4];
    private int xBufOff;
    private long byteCount;
    private int[] W = new int[68];
    private static final int[] T;

    public SM3() {
        this.reset();
    }

    public int getDigestSize() {
        return 32;
    }

    private void reset() {
        this.byteCount = 0L;
        this.xBufOff = 0;
        for (int i = 0; i < this.xBuf.length; ++i) {
            this.xBuf[i] = 0;
        }
        this.V[0] = 1937774191;
        this.V[1] = 1226093241;
        this.V[2] = 388252375;
        this.V[3] = -628488704;
        this.V[4] = -1452330820;
        this.V[5] = 372324522;
        this.V[6] = -477237683;
        this.V[7] = -1325724082;
        this.xOff = 0;
    }

    public int doFinal(byte[] out) {
        this.finish();
        SM3.intToBigEndian(this.V, out);
        return 32;
    }

    private static void intToBigEndian(int[] ns, byte[] bs) {
        int i = 0;
        int j = 0;
        while (i < ns.length) {
            SM3.intToBigEndian(ns[i], bs, j);
            ++i;
            j += 4;
        }
    }

    private static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    private void processWord(byte[] in, int inOff) {
        int var10000 = (in[inOff] & 0xFF) << 24;
        var10000 |= (in[++inOff] & 0xFF) << 16;
        var10000 |= (in[++inOff] & 0xFF) << 8;
        int n = var10000 | in[++inOff] & 0xFF;
        this.inwords[this.xOff++] = n;
        if (this.xOff >= 16) {
            this.processBlock();
        }
    }

    private int P0(int x) {
        int r9 = x << 9 | x >>> 23;
        int r17 = x << 17 | x >>> 15;
        return x ^ r9 ^ r17;
    }

    private int P1(int x) {
        int r15 = x << 15 | x >>> 17;
        int r23 = x << 23 | x >>> 9;
        return x ^ r15 ^ r23;
    }

    private int FF0(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private int FF1(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private int GG0(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private int GG1(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private void processBlock() {
        int E;
        int D;
        int C;
        int B;
        int A;
        System.arraycopy(this.inwords, 0, this.W, 0, 16);
        for (A = 16; A < 68; ++A) {
            B = this.W[A - 3];
            C = B << 15 | B >>> 17;
            D = this.W[A - 13];
            E = D << 7 | D >>> 25;
            this.W[A] = this.P1(this.W[A - 16] ^ this.W[A - 9] ^ C) ^ E ^ this.W[A - 6];
        }
        A = this.V[0];
        B = this.V[1];
        C = this.V[2];
        D = this.V[3];
        E = this.V[4];
        int F = this.V[5];
        int G = this.V[6];
        int H = this.V[7];
        for (int j = 0; j < 64; ++j) {
            int TT2;
            int TT1;
            int a12 = A << 12 | A >>> 20;
            int s1_ = a12 + E + T[j];
            int SS1 = s1_ << 7 | s1_ >>> 25;
            int SS2 = SS1 ^ a12;
            int Wj = this.W[j];
            int W1j = Wj ^ this.W[j + 4];
            if (j < 16) {
                TT1 = this.FF0(A, B, C) + D + SS2 + W1j;
                TT2 = this.GG0(E, F, G) + H + SS1 + Wj;
            } else {
                TT1 = this.FF1(A, B, C) + D + SS2 + W1j;
                TT2 = this.GG1(E, F, G) + H + SS1 + Wj;
            }
            D = C;
            C = B << 9 | B >>> 23;
            B = A;
            A = TT1;
            H = G;
            G = F << 19 | F >>> 13;
            F = E;
            E = this.P0(TT2);
        }
        int[] var10000 = this.V;
        var10000[0] = var10000[0] ^ A;
        var10000 = this.V;
        var10000[1] = var10000[1] ^ B;
        var10000 = this.V;
        var10000[2] = var10000[2] ^ C;
        var10000 = this.V;
        var10000[3] = var10000[3] ^ D;
        var10000 = this.V;
        var10000[4] = var10000[4] ^ E;
        var10000 = this.V;
        var10000[5] = var10000[5] ^ F;
        var10000 = this.V;
        var10000[6] = var10000[6] ^ G;
        var10000 = this.V;
        var10000[7] = var10000[7] ^ H;
        this.xOff = 0;
    }

    private void finish() {
        long bitLength = this.byteCount << 3;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(bitLength);
        this.processBlock();
    }

    private void update(byte in) {
        this.xBuf[this.xBufOff++] = in;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    private void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
            this.processBlock();
        }
        while (this.xOff < 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
        }
        this.inwords[this.xOff++] = (int)(bitLength >>> 32);
        this.inwords[this.xOff++] = (int)bitLength;
    }

    public void update(byte[] in, int inOff, int len) {
        len = Math.max(0, len);
        int i = 0;
        if (this.xBufOff != 0) {
            while (i < len) {
                this.xBuf[this.xBufOff++] = in[inOff + i++];
                if (this.xBufOff != 4) continue;
                this.processWord(this.xBuf, 0);
                this.xBufOff = 0;
                break;
            }
        }
        int limit = (len - i & 0xFFFFFFFC) + i;
        while (i < limit) {
            this.processWord(in, inOff + i);
            i += 4;
        }
        while (i < len) {
            this.xBuf[this.xBufOff++] = in[inOff + i++];
        }
        this.byteCount += (long)len;
    }

    static {
        int n;
        int i;
        T = new int[64];
        for (i = 0; i < 16; ++i) {
            n = 2043430169;
            SM3.T[i] = n << i | n >>> 32 - i;
        }
        for (i = 16; i < 64; ++i) {
            n = i % 32;
            int t = 2055708042;
            SM3.T[i] = t << n | t >>> 32 - n;
        }
    }
}

