/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.other;

import java.util.Base64;
import kd.bos.context.RequestContext;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.AESUtil;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.ebg.cus.api.ISDKFetchData;

public class FetchDataImpl
implements ISDKFetchData {
    public static final String DEV_PARAM = "devParam";
    public static final String PACKAGE_KEY = "pageKey";
    public static final String LAST_PAGE_KEY = "lastPageKey";

    public String getBankLoginConfigValues(String configID) {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        String tenantID = RequestContext.get().getTenantId();
        BankLoginConfigKey key = new BankLoginConfigKey();
        key.setBankConfigId(configID);
        key.setBankVersionId(bankVersionID);
        key.setBankLoginId(bankLoginID);
        key.setCustomID(tenantID);
        String value = "";
        BankLoginConfig bankLoginConfig = BankLoginConfigService.getInstance().getBankLoginConfig(key);
        if (bankLoginConfig != null) {
            value = bankLoginConfig.getBankConfigValue();
            if (StringUtils.isEmpty((String)bankLoginConfig.getInputType())) {
                value = AESUtil.unencryptedDesEncrypt((String)value, (String)bankLoginConfig.getId());
            } else if (ConfigInputType.PASSWORD.getInputType().equalsIgnoreCase(bankLoginConfig.getInputType())) {
                value = AESUtil.unencryptedDesEncrypt((String)value, (String)bankLoginConfig.getId());
            } else if (ConfigInputType.UPLOAD.getInputType().equalsIgnoreCase(bankLoginConfig.getInputType())) {
                value = this.loadCert(configID, bankLoginID, tenantID);
            }
        }
        return value;
    }

    public String loadCert(String bankConfigID, String bankLoginID, String customID) {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(bankConfigID, bankLoginID, customID);
        if (certInfo != null) {
            CipherInfo cipherInfo = FetchDataImpl.getCipherInfo(certInfo.getFileContent());
            byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
            return Base64.getEncoder().encodeToString(fileContent);
        }
        return "";
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    public String getBankBusinessConfigValue(String configID) {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        ObjectPropertiesKey key = this.getKey(configID, bankVersionID);
        return this.getPropertyValue(key);
    }

    public String getBankAcntConfigValue(String accNo, String configID) {
        ObjectPropertiesKey key = this.getKey(configID, accNo);
        return this.getPropertyValue(key);
    }

    public int getCurrentPage() {
        return Integer.parseInt(RequestContextUtils.getRunningParam((String)PACKAGE_KEY));
    }

    public void setCurrentPage(Object val) {
        String page = String.valueOf(val);
        if (StrUtil.isNotBlank((CharSequence)page)) {
            RequestContextUtils.setRunningParam((String)PACKAGE_KEY, (String)page);
        }
    }

    public boolean isLastPage() {
        return Boolean.parseBoolean(RequestContextUtils.getRunningParam((String)LAST_PAGE_KEY));
    }

    public void setLastPage(boolean val) {
        RequestContextUtils.setRunningParam((String)LAST_PAGE_KEY, (String)String.valueOf(val));
    }

    public void setDevParam(String val) {
        RequestContextUtils.setRunningParam((String)DEV_PARAM, (String)String.valueOf(val));
    }

    public String getDevParam() {
        return RequestContextUtils.getRunningParam((String)DEV_PARAM);
    }

    private String getPropertyValue(ObjectPropertiesKey key) {
        ObjectProperties objProperty = ObjectPropertiesRepository.getInstance().findById(key);
        if (objProperty != null) {
            return objProperty.getAttrValue();
        }
        return "";
    }

    private ObjectPropertiesKey getKey(String configID, String objectID) {
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setCustomID(RequestContext.get().getTenantId());
        key.setObjectName("BANK_BUSINESS");
        key.setObjectID(objectID);
        key.setAttrKey(configID);
        return key;
    }
}

