/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.service.sign;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.ebg.aqap.banks.cus.util.ShowTipUtil;
import kd.ebg.aqap.business.sign.AbstractSignImpl;
import kd.ebg.aqap.common.utils.ReflectUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.ebg.cus.api.biz.other.ISDKSign;
import kd.sdk.ebg.cus.api.biz.util.ISDKLoginSign;

public class SignImpl
extends AbstractSignImpl
implements ISDKLoginSign {
    EBGLogger logger = EBGLogger.getInstance().getLogger(SignImpl.class);
    private static Map<String, ISDKSign> signCacheMap = new HashMap<String, ISDKSign>(1);

    private ISDKSign getImplFromCache() {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        return this.getImplFromCache(bankVersionID);
    }

    private synchronized ISDKSign getImplFromCache(String bankVersionID) {
        Set clzImplSet;
        if (!signCacheMap.containsKey(bankVersionID) && (clzImplSet = ReflectUtil.getSubTypesOf(ISDKSign.class)) != null) {
            for (Class c : clzImplSet) {
                try {
                    ISDKSign instance = (ISDKSign)c.newInstance();
                    signCacheMap.put(instance.getBankVersionID(), instance);
                }
                catch (Throwable e) {
                    this.logger.error(ShowTipUtil.getNotFindClassTip(ISDKSign.class.getName()), e);
                }
            }
        }
        ISDKSign isdkSign = signCacheMap.get(bankVersionID);
        return isdkSign;
    }

    public String pack() {
        return null;
    }

    public String parse(String bankResponseStr) {
        ISDKSign impl = this.getImplFromCache();
        return impl.parse(bankResponseStr);
    }

    public String doBiz(String data) {
        ISDKSign impl = this.getImplFromCache();
        if (!impl.isBankSDK()) {
            return super.doBiz(data);
        }
        String bankRequestStr = this.pack(data);
        ShowTipUtil.recordRequest(bankRequestStr);
        try {
            String bankResponseStr = impl.sendAndReceive(bankRequestStr);
            ShowTipUtil.recordResponse(bankResponseStr);
            return this.parse(bankResponseStr);
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }

    public String getConnectionURI() {
        ISDKSign impl = this.getImplFromCache();
        return impl.getHttpUri();
    }

    public Map<String, String> getHttpHeader() {
        ISDKSign impl = this.getImplFromCache();
        return impl.getHttpHeader();
    }

    public String getSignature(String data) {
        return this.doBiz(data);
    }

    public void configFactory(ConnectionFactory factory) {
        ISDKSign impl = this.getImplFromCache();
        String uri = impl.getHttpUri();
        if (StringUtils.isNotEmpty((String)uri)) {
            factory.setUri(uri);
        }
        Map httpHeaderMap = impl.getHttpHeader();
        for (Map.Entry entry : httpHeaderMap.entrySet()) {
            factory.setHttpHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

