/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hfb.dc.services.login;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.ebg.aqap.banks.hfb.dc.services.login.LoginPacker;
import kd.ebg.aqap.banks.hfb.dc.services.login.LoginParser;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class LoginImpl {
    private EBGLogger log = EBGLogger.getInstance().getLogger(LoginImpl.class);
    private Date LoginDate;
    private LoginPacker loginPacker = new LoginPacker();
    private LoginParser loginParser = new LoginParser();
    private String token;
    private long lastActionTimestamp = Long.MAX_VALUE;
    private static final int timeout = 600;

    public String getToken() throws EBServiceException {
        String key = this.getCacheKey();
        String cache_token = CosmicCache.get((String)key);
        boolean unitTest = EBContext.getContext().isUnitTest();
        if (unitTest) {
            return "testToken";
        }
        if (StringUtils.isEmpty((String)cache_token)) {
            DLock lock = DLock.create((String)key, (String)ResManager.loadKDString((String)"\u6052\u4e30\u94f6\u884c\u83b7\u53d6\u767b\u5f55token\u5206\u5e03\u5f0f\u9501\u3002", (String)"LoginImpl_0", (String)"ebg-aqap-banks-hfb-dc", (Object[])new Object[0]));
            try {
                if (lock.tryLock()) {
                    cache_token = CosmicCache.get((String)key);
                    if (cache_token == null) {
                        this.login();
                        cache_token = this.token;
                    }
                } else {
                    long time;
                    for (time = 180000L; time >= 0L && (cache_token = CosmicCache.get((String)key)) == null; time -= 700L) {
                        Thread.sleep(700L);
                    }
                    if (time < 0L) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u6052\u4e30\u94f6\u884ctoken\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8bf7\u6c42\u3002", (String)"LoginImpl_1", (String)"ebg-aqap-banks-hfb-dc", (Object[])new Object[0]));
                    }
                }
            }
            catch (Exception e) {
                this.log.error("\u83b7\u53d6\u6052\u4e30\u94f6\u884ctoken\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u6052\u4e30\u94f6\u884ctoken\u51fa\u73b0\u5f02\u5e38\u3002", (String)"LoginImpl_2", (String)"ebg-aqap-banks-hfb-dc", (Object[])new Object[0]), (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return cache_token;
    }

    public String getCacheKey() {
        String customID = EBContext.getContext().getCustomID();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        return "eb_" + customID + "_" + bankLoginID + "_token";
    }

    private void login() throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(this.getClass());
        try {
            String rqstStr = this.loginPacker.packLogin();
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            factory.setUri("/HFYQService/APISessionReqServlet?opName=CebankUserLogonOp");
            factory.setHttpHeader("content-type", "text/xml; charset=GBK");
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream os = conn.getOutputStream();){
                IOUtils.sendFully((OutputStream)os, (String)rqstStr);
                logger.info("\u53d1\u9001\u6570\u636e\u5b8c\u6210");
                try (InputStream is = conn.getInputStream();){
                    String rspStr = IOUtils.readFully((InputStream)is);
                    this.token = this.loginParser.parseLogin(rspStr);
                    CosmicCache.putIfAbsentWithExpire((String)this.getCacheKey(), (String)this.token, (int)600, (TimeUnit)TimeUnit.SECONDS);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u6052\u4e30\u94f6\u884c\u767b\u5f55\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6052\u4e30\u94f6\u884c\u767b\u5f55\u51fa\u73b0\u5f02\u5e38\u3002", (String)"LoginImpl_3", (String)"ebg-aqap-banks-hfb-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

