/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hdb.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hdb.dc.services.HDBCommParser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = new Element("Message");
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2EActBalQry");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element listElement = JDomUtils.addChild((Element)body, (String)"List");
        Element mapElement = JDomUtils.addChild((Element)listElement, (String)"Map");
        JDomUtils.addChild((Element)mapElement, (String)"AcNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        BankResponse resp = HDBCommParser.parserCommonHead(s);
        if (!"000000".equals(resp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a:%s", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), resp.toString()));
        }
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BalanceInfo balanceInfo = new BalanceInfo();
        try {
            Element mapElement = root.getChild("Body").getChild("List").getChild("Map");
            String returnCode = mapElement.getChildTextTrim("ReturnCode");
            String returnMsg = mapElement.getChildTextTrim("ReturnMsg");
            if (!"000000".equals(returnCode)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a:%1$s,%2$s", (String)"BalanceImpl_7", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), returnCode, returnMsg));
            }
            String acNo = mapElement.getChildTextTrim("AcNo");
            if (!bankBalanceRequest.getAcnt().getAccNo().equals(acNo)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a:\u8bf7\u6c42\u8d26\u53f7[%1$s]\u4e0e\u94f6\u884c\u8fd4\u56de\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"BalanceImpl_8", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), bankBalanceRequest.getAcnt().getAccNo(), acNo));
            }
            String cur = mapElement.getChildTextTrim("Currency");
            String bal = mapElement.getChildTextTrim("Balance");
            String availBalance = mapElement.getChildTextTrim("AvailBal");
            balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
            balanceInfo.setBankCurrency(cur);
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            balanceInfo.setCurrentBalance(new BigDecimal(bal));
            if (!StringUtils.isEmpty((String)bal)) {
                balanceInfo.setAvailableBalance(new BigDecimal(availBalance));
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u4f59\u989d\u62a5\u6587\u4f53\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EActBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u90af\u90f8\u94f6\u884c\u5f53\u65e5\u4f59\u989d\u63a5\u53e3", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder uri = new StringBuilder();
        uri.append("/eweb/").append(this.getBizCode()).append(".do?");
        String accessNumber = RequestContextUtils.getBankParameterValue((String)"passWord");
        String signFlag = "1";
        uri.append("userPassword=").append(accessNumber).append("&SIGDATA=").append(signFlag);
        factory.setUri(uri.toString());
    }
}

