/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.anz.dc.service.payment.oversea.au.CBFT;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.anz.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.anz.dc.service.ANZ_DC_Packer;
import kd.ebg.aqap.banks.anz.dc.service.payment.oversea.Helper;
import kd.ebg.aqap.banks.anz.dc.service.payment.oversea.PayParser;
import kd.ebg.aqap.banks.anz.dc.service.payment.oversea.au.AU_CommonPacker;
import kd.ebg.aqap.banks.anz.dc.service.payment.oversea.querypay.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.TransactionRemarksUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public int getBatchSize() {
        return BankBusinessConfig.getBatchNumber();
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        Element simulator = new Element("simulator");
        Element head = ANZ_DC_Packer.createHead("XML");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        String content = this.packPayXml(bankPayRequest.getPaymentInfoAsArray());
        this.logger.info("\u4ed8\u6b3e\u62a5\u6587\uff1a" + content);
        String bankMsg = Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8));
        JDomUtils.addChild((Element)body, (String)"bankMsg", (String)bankMsg);
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public String packPayXml(PaymentInfo[] paymentInfos) {
        Element root = JDomUtils.createRoot((String)"Document");
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Namespace ns2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        root.setNamespace(ns1);
        root.addNamespaceDeclaration(ns2);
        Element CstmrCdtTrfInitn = JDomUtils.addChild((Element)root, (String)"CstmrCdtTrfInitn").setNamespace(ns1);
        Element GrpHdr = AU_CommonPacker.packPayXmlhead(paymentInfos, CstmrCdtTrfInitn, ns1);
        Element PmtInf = AU_CommonPacker.packPayXmlPmtInfo(paymentInfos, CstmrCdtTrfInitn);
        BigDecimal totalAmount = new BigDecimal("0.00");
        Helper helper = new Helper();
        for (PaymentInfo info : paymentInfos) {
            String exp;
            Element CdtTrfTxInf = JDomUtils.addChild((Element)PmtInf, (String)"CdtTrfTxInf").setNamespace(ns1);
            Element PmtId = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"PmtId").setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"EndToEndId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            Element Amt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Amt").setNamespace(ns1);
            Element InstdAmt = JDomUtils.addChild((Element)Amt, (String)"InstdAmt", (String)info.getActualAmount().toString()).setNamespace(ns1);
            totalAmount = totalAmount.add(info.getActualAmount());
            InstdAmt.setAttribute("Ccy", info.getPayCurrency());
            if (info.getPayerFeeType().equals("01")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns1);
            } else if (info.getPayerFeeType().equals("02")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns1);
            } else if (info.getPayerFeeType().equals("03")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns1);
            }
            Element CdtrAgt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAgt").setNamespace(ns1);
            Element CdtrAgt_FinInstnId = JDomUtils.addChild((Element)CdtrAgt, (String)"FinInstnId").setNamespace(ns1);
            if (!StringUtils.isEmpty((String)info.getIncomeSwiftCode())) {
                JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"BIC", (String)info.getIncomeSwiftCode()).setNamespace(ns1);
            }
            if (!StringUtils.isEmpty((String)info.getIncomeBankLocalClearingCode())) {
                Element ClrSysMmbId = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"ClrSysMmbId").setNamespace(ns1);
                JDomUtils.addChild((Element)ClrSysMmbId, (String)"MmbId", (String)info.getIncomeBankLocalClearingCode()).setNamespace(ns1);
            }
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"Nm", (String)info.getIncomeBankName()).setNamespace(ns1);
            Element CdtrAgt_FinInstnId_PstlAdr = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"PstlAdr").setNamespace(ns1);
            String benefitBankAddress = info.getIncomeBankAddress();
            helper.addressSplit(CdtrAgt_FinInstnId_PstlAdr, benefitBankAddress, ns1);
            CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
            if (null == code) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\uff1a%1$s \u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"PaymentImpl_5", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), info.getIncomeCountry()));
            }
            String ctry = code.geteChart2();
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId_PstlAdr, (String)"Ctry", (String)ctry).setNamespace(ns1);
            String name = info.getIncomeAccName();
            Element Cdtr = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Cdtr").setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)helper.formatStringByLength(name, 35)).setNamespace(ns1);
            Element Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns1);
            String tocity = PaymentInfoSysFiled.get((PaymentInfo)info, (String)"tocity");
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"TwnNm", (String)tocity).setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Ctry", (String)ctry).setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"AdrLine", (String)info.getIncomeAddress()).setNamespace(ns1);
            Element CdtrAcct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAcct").setNamespace(ns1);
            Element CdtrAcct_Id = JDomUtils.addChild((Element)CdtrAcct, (String)"Id").setNamespace(ns1);
            Element CdtrAcct_Id_Othr = JDomUtils.addChild((Element)CdtrAcct_Id, (String)"Othr").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct_Id_Othr, (String)"Id", (String)info.getIncomeAccNo()).setNamespace(ns1);
            if ("CN".equals(ctry) && "CNY".equals(info.getPayCurrency())) {
                if (StringUtils.isEmpty((String)info.getTransactionRemarks())) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"CBFT\u4ed8\u6b3e\uff0c\u6536\u6b3e\u5730\u533a\u4e3a\u4e2d\u56fd\u5927\u9646\uff0c\u6536\u6b3e\u5e01\u79cd\u4e3a\u4eba\u6c11\u5e01\u65f6\uff0c\u4eba\u6c11\u5e01\u6e05\u7b97\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]));
                }
                String transactionRemark = TransactionRemarksUtils.getInstance().getTransactionRemark(info.getTransactionRemarks(), info.getBankVersionID());
                Element InstrForCdtrAgt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"InstrForCdtrAgt").setNamespace(ns1);
                JDomUtils.addChild((Element)InstrForCdtrAgt, (String)"InstrInf", (String)transactionRemark).setNamespace(ns1);
            }
            if (StringUtils.isEmpty((String)(exp = info.getExplanation()))) continue;
            Element RmtInf = JDomUtils.getChildElement((Element)CdtTrfTxInf, (String)"RmtInf");
            if (RmtInf == null) {
                RmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RmtInf").setNamespace(ns1);
            }
            List<String> list = Helper.getStrList(exp, 35);
            for (String string : list) {
                JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)string).setNamespace(ns1);
            }
        }
        Element CtrlSum = GrpHdr.getChild("CtrlSum", ns1);
        CtrlSum.addContent(totalAmount.toString());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PayParser.parsePay(paymentInfos, s);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

