/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.czccb.dc.service.payment.company;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.czccb.dc.service.Packer;
import kd.ebg.aqap.banks.czccb.dc.service.Parser;
import kd.ebg.aqap.banks.czccb.dc.service.SignService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;

final class PayPacker {
    PayPacker() {
    }

    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        String header;
        EBGLogger logger = EBGLogger.getInstance().getLogger(PayPacker.class);
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8f6c\u8d26\u4ea4\u6613\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"PayPacker_0", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]));
        }
        String body = "";
        if (Parser.isSameBank(paymentInfos[0], logger)) {
            header = Packer.createHeadMessage("CBE020102");
            body = this.createSameBankBody(paymentInfos[0]);
        } else {
            header = Packer.createHeadMessage("CBE020103");
            body = this.createBody(paymentInfos[0]);
        }
        String reqMsg = header + body;
        String signData = SignService.getSignData(reqMsg, "UTF-8");
        reqMsg = header + body + signData;
        String strLen = Packer.getLength(reqMsg);
        return strLen + reqMsg;
    }

    private String createBody(PaymentInfo paymentInfo) {
        StringBuilder sbBody = new StringBuilder();
        String encoding = "UTF-8";
        try {
            sbBody.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\"?>\r\n");
            sbBody.append("<BankData>");
            sbBody.append("<opReq>");
            sbBody.append("<ReqParam>");
            sbBody.append("<payAccount>").append(paymentInfo.getAccNo()).append("</payAccount>");
            sbBody.append("<payAccountName>").append(paymentInfo.getAccName()).append("</payAccountName>");
            sbBody.append("<currencyType>CNY</currencyType>");
            sbBody.append("<payAmount>").append(paymentInfo.getAmount().toString()).append("</payAmount>");
            sbBody.append("<payUse>").append(ResManager.loadKDString((String)"(\u94f6\u4f01\u4e92\u8054)", (String)"PayPacker_1", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0])).append(paymentInfo.getExplanation()).append("</payUse>");
            sbBody.append("<recAccount>").append(paymentInfo.getIncomeAccNo()).append("</recAccount>");
            sbBody.append("<recAccountName>").append(paymentInfo.getIncomeAccName()).append("</recAccountName>");
            sbBody.append("<unionBankNo>").append(paymentInfo.getIncomeCnaps()).append("</unionBankNo>");
            sbBody.append("<chargeFee>0.00</chargeFee>");
            String isUrgent = "0";
            if (!paymentInfo.is2Urgent()) {
                isUrgent = "1";
            }
            BigDecimal amout1 = paymentInfo.getAmount();
            BigDecimal amout2 = BigDecimal.valueOf(20000.0);
            if (amout2.compareTo(amout1) >= 0) {
                isUrgent = "1";
            }
            sbBody.append("<payMethodType>").append(isUrgent).append("</payMethodType>");
            sbBody.append("<currIden>0</currIden>");
            sbBody.append("<orderFlowNo>").append(paymentInfo.getBankRefID()).append("</orderFlowNo>");
            sbBody.append("</ReqParam>");
            sbBody.append("</opReq>");
            sbBody.append("</BankData>");
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return sbBody.toString();
    }

    private String createSameBankBody(PaymentInfo paymentInfo) {
        StringBuilder sbBody = new StringBuilder();
        String encoding = "UTF-8";
        try {
            sbBody.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\"?>\r\n");
            sbBody.append("<BankData>");
            sbBody.append("<opReq>");
            sbBody.append("<ReqParam>");
            sbBody.append("<payAccount>").append(paymentInfo.getAccNo()).append("</payAccount>");
            sbBody.append("<payAccountName>").append(paymentInfo.getAccName()).append("</payAccountName>");
            sbBody.append("<payAmount>").append(paymentInfo.getAmount().toString()).append("</payAmount>");
            sbBody.append("<payUse>").append(ResManager.loadKDString((String)"(\u94f6\u4f01\u4e92\u8054)", (String)"PayPacker_1", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0])).append(paymentInfo.getExplanation()).append("</payUse>");
            sbBody.append("<recAccount>").append(paymentInfo.getIncomeAccNo()).append("</recAccount>");
            sbBody.append("<recAccountName>").append(paymentInfo.getIncomeAccName()).append("</recAccountName>");
            sbBody.append("<orderFlowNo>").append(paymentInfo.getBankRefID()).append("</orderFlowNo>");
            sbBody.append("</ReqParam>");
            sbBody.append("</opReq>");
            sbBody.append("</BankData>");
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return sbBody.toString();
    }
}

