/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ocbcsg.dc.services.payment.ift;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.aqap.banks.ocbcsg.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ocbcsg.dc.OcbcSgMetaDataImpl;
import kd.ebg.aqap.banks.ocbcsg.dc.services.payment.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.bank.AbstractOverseaPayImpl;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.commons.lang3.StringUtils;

public class PayImpl
extends AbstractOverseaPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        String bookTime;
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        StringBuilder sb = new StringBuilder();
        String productid = StringUtils.rightPad((String)"IFT", (int)4, (String)" ");
        sb.append(productid);
        String bankDetailSeqID = StringUtils.rightPad((String)paymentInfo.getBankDetailSeqID(), (int)16, (String)" ");
        sb.append(bankDetailSeqID);
        String accNo = StringUtils.rightPad((String)paymentInfo.getAccNo(), (int)14, (String)" ");
        sb.append(accNo);
        String currency = StringUtils.rightPad((String)paymentInfo.getCurrency(), (int)3, (String)" ");
        sb.append(currency);
        if (paymentInfo.getBookingTime() != null) {
            bookTime = paymentInfo.getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            PaymentUtil.setBookPayFlag((List)bankPayRequest.getPaymentInfos());
        } else {
            bookTime = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        sb.append(bookTime);
        sb.append(currency);
        String amount = StringUtils.rightPad((String)paymentInfo.getAmount().toString(), (int)15, (String)" ");
        sb.append(amount);
        sb.append("N");
        sb.append(" ");
        sb.append(StringUtils.rightPad((String)"", (int)3, (String)" "));
        String incomeAccNo = StringUtils.rightPad((String)paymentInfo.getIncomeAccNo(), (int)35, (String)" ");
        sb.append(incomeAccNo);
        sb.append(currency);
        String incomeAccName = StringUtils.rightPad((String)paymentInfo.getIncomeAccName(), (int)35, (String)" ");
        sb.append(incomeAccName);
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)4, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)3, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)2, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)2, (String)" "));
        sb.append(StringUtils.rightPad((String)paymentInfo.getExplanation(), (int)140, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)180, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)30, (String)" "));
        String emails = paymentInfo.getEmails();
        if (StringUtils.isNotBlank((CharSequence)emails)) {
            sb.append("E");
            sb.append(StringUtils.rightPad((String)emails, (int)50, (String)" "));
        } else {
            sb.append(" ");
            sb.append(StringUtils.rightPad((String)"", (int)50, (String)" "));
        }
        sb.append(StringUtils.rightPad((String)"", (int)24, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)256, (String)" "));
        sb.append(" ");
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)11, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)35, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)12, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)15, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)15, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)15, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)15, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)15, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)11, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)11, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)16, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)16, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)180, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)180, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)4, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)30, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)4, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)30, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)4, (String)" "));
        sb.append(StringUtils.rightPad((String)"", (int)30, (String)" "));
        return sb.toString();
    }

    protected String getPayFileName(BankPayRequest bankPayRequest) {
        StringBuilder sb = new StringBuilder();
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String prefix = RequestContextUtils.getBankParameterValue((String)OcbcSgMetaDataImpl.pay_file_name);
        String payFilePrefix = BankBusinessConfig.getPayFilePrefix(paymentInfo.getAccNo());
        if (StringUtils.isNotBlank((CharSequence)payFilePrefix)) {
            prefix = payFilePrefix;
        }
        sb.append(prefix).append("_").append("IFTP").append("_").append("ALLSWIFT").append("_").append(paymentInfo.getBankBatchSeqID()).append("_").append(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append("_").append(LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss"))).append(".txt.pgp");
        return sb.toString();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "IFT";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.getUseCN().equalsIgnoreCase("IFT");
    }
}

