/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opb.service.payment.single;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.opb.util.Packer;
import kd.ebg.aqap.banks.gdb.opb.util.Parser;
import kd.ebg.aqap.banks.gdb.opb.util.SendUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class QuerySinglePayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public EBBankPayResponse doBiz(BankPayRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = SendUtil.send(this.getBizCode(), rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Header", (Object)Packer.createHeader(this.getBizCode()));
        JSONObject body = new JSONObject();
        jsonObject.put("Body", (Object)body);
        body.put("oriEntBizDt", (Object)LocalDateUtil.formatDate((LocalDateTime)paymentInfo.getSubmitSuccessTime()));
        body.put("oriEntBizId", (Object)paymentInfo.getBankBatchSeqID());
        return jsonObject.toString();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        BankResponse response = Parser.parseHeader(jsonObject.getJSONObject("Header"));
        if (!"000000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        JSONObject body = jsonObject.getJSONObject("Body");
        String sysRetCode = body.getString("bizRetCode");
        String sysRetInfo = body.getString("bizRetInfo");
        if ("DEIBISEEER0201".equals(sysRetCode)) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.FAIL, (String)"", (String)sysRetCode, (String)sysRetInfo);
        } else if (!"000000".equals(sysRetCode)) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)sysRetCode, (String)sysRetInfo);
        } else {
            String oriBizSts = body.getString("oriBizSts");
            String oriBizRetInfo = body.getString("oriBizRetInfo");
            if ("0".equals(oriBizSts)) {
                EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.FAIL, (String)"", (String)oriBizSts, (String)oriBizRetInfo);
            } else if ("2".equals(oriBizSts)) {
                EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)"", (String)oriBizSts, (String)oriBizRetInfo);
            } else if ("1".equals(oriBizSts)) {
                EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUCCESS, (String)"", (String)oriBizSts, (String)oriBizRetInfo);
            } else {
                EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)oriBizSts, (String)oriBizRetInfo);
            }
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "1004";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5355\u7b14\u8f6c\u8d26\u7ed3\u679c\u3002", (String)"QuerySinglePayImpl_0", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]);
    }
}

