/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zrc.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zrc.dc.util.Request;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/eweb-query.BSQueryBalOp.do?";
        s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("user_password") + "&SIGDATA=1";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String pack(BankBalanceRequest request) {
        Element root = new Element("ROOT");
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)root, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"opName", (String)"BSQueryBalOp");
        Element body = new Element("ReqParam");
        String Areacode = request.getAcnt().getAreaCode();
        JDomUtils.addChild((Element)body, (String)"Area_code", (String)Areacode);
        String acNoStr = request.getAcnt().getAccNo();
        JDomUtils.addChild((Element)body, (String)"Account_num", (String)acNoStr);
        String cur = request.getBankCurrency();
        JDomUtils.addChild((Element)body, (String)"Account_cur", (String)cur);
        JDomUtils.addChild((Element)body, (String)"userID", (String)RequestContextUtils.getBankParameterValue((String)"userid"));
        JDomUtils.addChild((Element)body, (String)"PackageID", (String)Sequence.gen14Sequence());
        JDomUtils.addChild((Element)body, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)opReq, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return RspMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElement((Element)root, (String)"opRep");
        Element opResult = JDomUtils.getChildElement((Element)opRep, (String)"opResult");
        String retCode = JDomUtils.getChildText((Element)opResult, (String)"retCode");
        String errMsg = JDomUtils.getChildText((Element)opResult, (String)"errMsg");
        if ("1".equals(retCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u8fd4\u56de\u7801\u4e3a1\uff0c%s", (String)"BalanceImpl_7", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]), errMsg));
        }
        if (retCode == null || !"0".equals(retCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u8fd4\u56de\u7801\u4e3a%1$s,%2$s", (String)"BalanceImpl_8", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]), retCode == null ? ResManager.loadKDString((String)"\u7a7a", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]) : retCode, errMsg));
        }
        String Acc_balance = Request.processBalance(JDomUtils.getChildText((Element)opResult, (String)"Acc_balance"));
        String Balance = Request.processBalance(JDomUtils.getChildText((Element)opResult, (String)"Balance"));
        String Usable_balance = Request.processBalance(JDomUtils.getChildText((Element)opResult, (String)"Usable_balance"));
        String Account_num = JDomUtils.getChildText((Element)opResult, (String)"Account_num");
        String Account_cur = JDomUtils.getChildText((Element)opResult, (String)"Account_cur");
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setBankCurrency(balanceInfo, Account_cur);
        this.setCurrentBalance(balanceInfo, Balance);
        this.setAvailableBalance(balanceInfo, Usable_balance);
        this.setLastDayAvlBalance(balanceInfo, Acc_balance);
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        this.setBankAcnt(balanceInfo, rqst.getBankAcntList(), Account_num);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "BSQueryBalOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u8d26\u6237\u4f59\u989d\u63a5\u53e3", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]);
    }

    public boolean async() {
        return false;
    }
}

