/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsnx.dc.service.payment;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.ebg.aqap.banks.gsnx.dc.service.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.CommonPacker;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.CommonParser;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.GSNXConstants;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest request) {
        JSONObject body = new JSONObject();
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        body.put("pay_acno", (Object)paymentInfo.getAccNo());
        body.put("pay_acname", (Object)paymentInfo.getAccName());
        body.put("rcv_acno", (Object)paymentInfo.getIncomeAccNo());
        body.put("rcv_acname", (Object)paymentInfo.getIncomeAccName());
        body.put("rcv_bank_no", (Object)paymentInfo.getIncomeCnaps());
        body.put("rcv_bank_name", (Object)paymentInfo.getIncomeBankName());
        body.put("amt", (Object)paymentInfo.getAmount().toString());
        body.put("bank_flag", (Object)(paymentInfo.is2SameBank() ? "0" : "1"));
        body.put("postscript", (Object)paymentInfo.getExplanation());
        return CommonPacker.createRootMsg(body, GSNXConstants.PAY, paymentInfo.getBankDetailSeqId());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        CommonParser.getRespBody(res);
        EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)"", (String)"");
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return GSNXConstants.PAY.getEnName();
    }

    public String getBizDesc() {
        return GSNXConstants.PAY.getCnName();
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

