/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsnx.dc.service.utils;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import kd.ebg.egf.common.log.EBGLogger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.util.encoders.Hex;

public class SMUtil {
    public static final int RS_LEN = 32;
    private static final String SIGNATURE_PARAM = "SM3withSM2";
    private static final String PROV_NAME = "BC";
    private static final String CURVE_NAME = "sm2p256v1";
    private static final X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
    private static final ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
    private static final String CIPHER_PARAM = "SM4";
    private static final String MODE_PARAM = "SM4/ECB/PKCS7Padding";
    private static BouncyCastleProvider bouncyCastleProvider = null;

    public static synchronized BouncyCastleProvider getProviderInstance() {
        if (bouncyCastleProvider == null) {
            bouncyCastleProvider = new BouncyCastleProvider();
        }
        return bouncyCastleProvider;
    }

    private static BCECPublicKey getECPublicKeyByPublicKeyHex(String pubKeyHex) {
        if (pubKeyHex.length() > 128) {
            pubKeyHex = pubKeyHex.substring(pubKeyHex.length() - 128);
        }
        String stringX = pubKeyHex.substring(0, 64);
        String stringY = pubKeyHex.substring(stringX.length());
        BigInteger x = new BigInteger(stringX, 16);
        BigInteger y = new BigInteger(stringY, 16);
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(x9ECParameters.getCurve().createPoint(x, y), ecParameterSpec);
        return new BCECPublicKey("EC", ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    private static byte[] innerSM2Encrypt(BCECPublicKey publicKey, String data, int modeType) throws InvalidCipherTextException {
        SM2Engine.Mode mode = SM2Engine.Mode.C1C3C2;
        if (modeType != 1) {
            mode = SM2Engine.Mode.C1C2C3;
        }
        ECParameterSpec ecParameterSpec = publicKey.getParameters();
        ECDomainParameters ecDomainParameters = new ECDomainParameters(ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN());
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(publicKey.getQ(), ecDomainParameters);
        SM2Engine sm2Engine = new SM2Engine(mode);
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)ecPublicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = null;
        byte[] in = data.getBytes(StandardCharsets.UTF_8);
        arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
        return arrayOfBytes;
    }

    public byte[] sm2Encrypt(String hexPublicKey, String plainText) throws InvalidCipherTextException {
        BCECPublicKey publicKey = SMUtil.getECPublicKeyByPublicKeyHex(hexPublicKey);
        byte[] encText = SMUtil.innerSM2Encrypt(publicKey, plainText, 1);
        return encText;
    }

    private static BCECPrivateKey getBCECPrivateKeyByPrivateKeyHex(String privateKeyHex) {
        BigInteger d = new BigInteger(privateKeyHex, 16);
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, ecParameterSpec);
        return new BCECPrivateKey("EC", ecPrivateKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    private static byte[] innerSM2Decrypt(BCECPrivateKey privateKey, byte[] cipherData, int modeType) throws InvalidCipherTextException {
        SM2Engine.Mode mode = SM2Engine.Mode.C1C3C2;
        if (modeType != 1) {
            mode = SM2Engine.Mode.C1C2C3;
        }
        ECParameterSpec ecParameterSpec = privateKey.getParameters();
        ECDomainParameters ecDomainParameters = new ECDomainParameters(ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN());
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(privateKey.getD(), ecDomainParameters);
        SM2Engine sm2Engine = new SM2Engine(mode);
        sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        byte[] arrayOfBytes = sm2Engine.processBlock(cipherData, 0, cipherData.length);
        return arrayOfBytes;
    }

    public String sm2Decrypt(String hexPrivateKey, byte[] encBytes) throws InvalidCipherTextException {
        BCECPrivateKey privateKey = SMUtil.getBCECPrivateKeyByPrivateKeyHex(hexPrivateKey);
        byte[] decResult = SMUtil.innerSM2Decrypt(privateKey, encBytes, 1);
        return new String(decResult, StandardCharsets.UTF_8);
    }

    private static byte[] signature(byte[] src, BCECPrivateKey sm2Key) throws Exception {
        byte[] dest = null;
        Signature signature = Signature.getInstance(SIGNATURE_PARAM, (Provider)SMUtil.getProviderInstance());
        signature.setParameter((AlgorithmParameterSpec)new SM2ParameterSpec("unionpay".getBytes()));
        signature.initSign((PrivateKey)sm2Key);
        signature.update(src);
        dest = signature.sign();
        return SMUtil.ans1ToRS(dest);
    }

    private static byte[] ans1ToRS(byte[] rsDer) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)rsDer);
        byte[] r = SMUtil.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue());
        byte[] s = SMUtil.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        byte[] result = new byte[64];
        System.arraycopy(r, 0, result, 0, r.length);
        System.arraycopy(s, 0, result, 32, s.length);
        return result;
    }

    private static byte[] bigIntToFixexLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return Arrays.copyOfRange(rs, 1, 33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            Arrays.fill(result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new RuntimeException("err rs: " + Hex.toHexString((byte[])rs));
    }

    public byte[] sm2Sign(String hexPrivateKey, String sortedString) throws Exception {
        BCECPrivateKey privateKey = SMUtil.getBCECPrivateKeyByPrivateKeyHex(hexPrivateKey);
        byte[] signResult = SMUtil.signature(sortedString.getBytes(StandardCharsets.UTF_8), privateKey);
        return signResult;
    }

    private static byte[] rsPlainByteArrayToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new RuntimeException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(sign, 0, 32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(sign, 32, 64));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean verifySignature(byte[] src, byte[] sign, BCECPublicKey sm2Key) throws Exception {
        byte[] sign_asn1 = SMUtil.rsPlainByteArrayToAsn1(sign);
        Signature signature = Signature.getInstance(SIGNATURE_PARAM, (Provider)SMUtil.getProviderInstance());
        signature.setParameter((AlgorithmParameterSpec)new SM2ParameterSpec("unionpay".getBytes()));
        signature.initVerify((PublicKey)sm2Key);
        signature.update(src);
        boolean res = signature.verify(sign_asn1);
        return res;
    }

    public boolean sm2SignValidate(String hexPublicKey, byte[] value, String sortedString) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(SMUtil.class);
        try {
            BCECPublicKey publicKey = SMUtil.getECPublicKeyByPublicKeyHex(hexPublicKey);
            return SMUtil.verifySignature(sortedString.getBytes("utf-8"), value, publicKey);
        }
        catch (Exception e) {
            logger.error("\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }
}

