/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.utils.FileContentWriterUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OverseaSFTPUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(OverseaSFTPUtils.class);
    private static OverseaSFTPUtils instance = null;

    public static synchronized OverseaSFTPUtils getInstance() {
        if (instance == null) {
            instance = new OverseaSFTPUtils();
        }
        return instance;
    }

    private OverseaSFTPUtils() {
    }

    public boolean upload(String uploadFilePath, ChannelSftp sftp) {
        return this.upload(FileCommonUtils.getFileByPath((String)uploadFilePath), sftp);
    }

    public boolean upload(File uploadFile, ChannelSftp sftp) {
        try {
            EBContext context = EBContext.getContext();
            IParameter parameter = context.getParameter();
            String ftpPath = parameter.getBankParameter("ftp_upload_path");
            return this.upload(ftpPath, uploadFile, sftp);
        }
        catch (Exception e) {
            logger.error("SFTP\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadAllFiles(String desFileDir, String ignoreFile) {
        ChannelSftp sftp = null;
        try {
            EBContext context = EBContext.getContext();
            IParameter parameter = context.getParameter();
            String ftpPath = parameter.getBankParameter("ftp_download_path");
            ftpPath = this.parseFormat(ftpPath);
            sftp = this.connect();
            logger.info("\u5efa\u7acbSFTP\u8fde\u63a5\u6210\u529f\u3002");
            Vector allFiles = sftp.ls(ftpPath);
            Iterator iterator = allFiles.iterator();
            while (iterator.hasNext()) {
                ChannelSftp.LsEntry downloadFile = (ChannelSftp.LsEntry)iterator.next();
                boolean dir = downloadFile.getAttrs().isDir();
                if (!dir) continue;
                iterator.remove();
            }
            logger.info("SFTP\u8def\u5f84\u4e3a\uff1a" + ftpPath + "\uff0c\u83b7\u53d6\u5230\u6587\u4ef6\u6570\uff1a" + allFiles.size());
            this.downloadBatchFiles(ftpPath, allFiles, desFileDir, sftp, ignoreFile);
        }
        catch (SftpException e) {
            logger.error("\u83b7\u53d6\u5f85\u4e0b\u8f7d\u6587\u4ef6\u5217\u8868\u5931\u8d25\u3002", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("SFTP\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)e);
        }
        finally {
            logger.info("\u91ca\u653eSFTP\u8fde\u63a5\u5f00\u59cb\u3002");
            try {
                if (sftp != null) {
                    Session session = sftp.getSession();
                    sftp.disconnect();
                    if (session != null) {
                        session.disconnect();
                    }
                }
            }
            catch (JSchException e) {
                logger.error("\u91ca\u653eSFTP\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
            }
            logger.info("\u91ca\u653eSFTP\u8fde\u63a5\u6210\u529f\u3002");
        }
    }

    public ChannelSftp startConnect(String host, int port, String username, String ftpPassword, String ftpCertFileName, String ftpCertPassword) throws JSchException {
        String ftpCert;
        JSch jsch = new JSch();
        logger.info("\u51c6\u5907\u5efa\u7acbSFTP\u8fde\u63a5\u3002");
        if (!StringUtils.isEmpty((String)ftpCertFileName) && StringUtils.isNotEmpty((String)(ftpCert = OverseaSFTPUtils.getFtpCert()))) {
            File cert = FileCommonUtils.getFileByPath((String)this.getFtpCertPath(), (String)ftpCertFileName);
            String ftpCertPath = this.getFtpCertPath() + File.separator + ftpCertFileName;
            if (!cert.exists()) {
                logger.info("\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u4fdd\u5b58\u5230\u5bf9\u5e94\u76ee\u5f55:" + ftpCertPath);
                FileContentWriterUtil.writeUTF8FileContent(ftpCertPath, ftpCert);
                File fileByPath = FileCommonUtils.getFileByPath((String)ftpCertPath);
                if (fileByPath.exists()) {
                    logger.info("\u8bc1\u4e66\u4fdd\u5b58\u6210\u529f");
                }
            }
            if (StringUtils.isEmpty((String)ftpCertPassword)) {
                jsch.addIdentity(ftpCertPath);
            } else {
                jsch.addIdentity(ftpCertPath, ftpCertPassword);
            }
        }
        Session session = jsch.getSession(username, host, port);
        session.setConfig("StrictHostKeyChecking", "no");
        session.setTimeout(120000);
        if (!StringUtils.isEmpty((String)ftpPassword)) {
            session.setPassword(ftpPassword);
        }
        session.connect(10000);
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp sftp = (ChannelSftp)channel;
        logger.info("Connected to " + host + ".");
        return sftp;
    }

    public ChannelSftp connect() throws JSchException {
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String ftpIP = parameter.getBankParameter("ip");
        String ftpPortStr = parameter.getBankParameter("exchangePort");
        String ftpCertPath = parameter.getBankParameter("ftp_cert_path");
        String ftpUserName = parameter.getBankParameter("ftp_user_name");
        String ftpPassword = parameter.getBankParameter("ftp_password");
        String ftpCertPassword = parameter.getBankParameter("ftp_cert_password");
        int ftpPort = Integer.parseInt(ftpPortStr);
        int count = 0;
        int timeoutCount = 3;
        int time = 5;
        while (count <= timeoutCount) {
            try {
                return this.startConnect(ftpIP, ftpPort, ftpUserName, ftpPassword, ftpCertPath, ftpCertPassword);
            }
            catch (JSchException e) {
                if (++count <= timeoutCount) {
                    logger.error("SFTP\u5efa\u7acb\u8fde\u63a5\u51fa\u9519", (Throwable)e);
                    try {
                        Thread.sleep(time * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error(interruptedException.getMessage());
                    }
                    logger.error("\u51c6\u5907\u7b2c" + count + "\u6b21\u91cd\u8fde");
                    continue;
                }
                logger.info("SFTP\u91cd\u8fde\u5df2\u8d85\u51fa\u6700\u5927\u6b21\u6570");
                throw e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upload(String directory, File uploadFile, ChannelSftp sftp) {
        if (!uploadFile.exists()) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u5f85\u4e0a\u4f20\u6587\u4ef6[" + uploadFile.getAbsolutePath() + "]\u4e0d\u5b58\u5728");
            return false;
        }
        FileInputStream fis = null;
        try {
            sftp.cd(directory);
            fis = new FileInputStream(uploadFile);
            try {
                sftp.put((InputStream)fis, uploadFile.getName());
                logger.info("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f!");
            }
            catch (Exception e) {
                logger.error("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                boolean bl = false;
                try {
                    sftp.disconnect();
                    this.clear(sftp.getSession());
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (JSchException | IOException e2) {
                    logger.error("\u5173\u95edSFTP\u8fde\u63a5\u51fa\u9519", e2);
                }
                return bl;
            }
            boolean e = true;
            return e;
        }
        catch (FileNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u5f85\u4e0a\u4f20\u6587\u4ef6" + uploadFile.getAbsolutePath(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (SftpException e) {
            logger.error("SFTP\u8fde\u63a5\u5f02\u5e38\u3002", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                sftp.disconnect();
                this.clear(sftp.getSession());
                if (fis != null) {
                    fis.close();
                }
            }
            catch (JSchException | IOException e) {
                logger.error("\u5173\u95edSFTP\u8fde\u63a5\u51fa\u9519", e);
            }
        }
    }

    private void downloadBatchFiles(String directory, Vector downloadFiles, String saveFilePath, ChannelSftp sftp, String ignoreFilePrefix) {
        if (downloadFiles == null || downloadFiles.isEmpty()) {
            return;
        }
        File saveFile = FileCommonUtils.getFileByPath((String)saveFilePath);
        if (!saveFile.exists() && !saveFile.isDirectory()) {
            saveFile.mkdirs();
        }
        String is_need_delete_file = null;
        Map runningParams = EBContext.getContext().getRunningParams();
        if (!CollectionUtils.isEmpty((Map)runningParams)) {
            is_need_delete_file = (String)EBContext.getContext().getRunningParams().get("is_need_delete_file");
        }
        boolean need_delete_file = Boolean.parseBoolean(is_need_delete_file);
        try {
            logger.info("\u5207\u6362\u5230Sftp\u76ee\u5f55\uff1a" + directory);
            sftp.cd(directory);
            int length = downloadFiles.size();
            for (int i = 0; i < length; ++i) {
                ChannelSftp.LsEntry downloadFile = (ChannelSftp.LsEntry)downloadFiles.get(i);
                String downloadFileName = downloadFile.getFilename();
                if (".".equalsIgnoreCase(downloadFileName) || "..".equalsIgnoreCase(downloadFileName) || StringUtils.isNotEmpty((String)ignoreFilePrefix) && downloadFileName.startsWith(ignoreFilePrefix)) continue;
                try {
                    sftp.get(downloadFileName, saveFilePath);
                    logger.info("\u4e0b\u8f7d\u6587\u4ef6" + downloadFileName + "\u5230" + saveFilePath + "\u6210\u529f");
                    if (!need_delete_file) continue;
                    try {
                        sftp.rm(directory + "/" + downloadFileName);
                        logger.info("\u4e0b\u8f7d\u6587\u4ef6\u5b8c\u6210\u540e\u5220\u9664sftp\u4e0a\u5bf9\u5e94\u6587\u4ef6\u6210\u529f");
                    }
                    catch (SftpException e) {
                        logger.error("\u5220\u9664sftp\u4e0a\u6587\u4ef6\uff1a" + downloadFileName + "\u5931\u8d25,\u5ffd\u7565\u6b64\u6b65", (Throwable)e);
                    }
                    continue;
                }
                catch (SftpException e) {
                    logger.error("\u4e0b\u8f7d\u6587\u4ef6" + downloadFileName + "\u5931\u8d25:{}", new Object[]{e.getCause().getMessage()});
                }
            }
        }
        catch (SftpException e) {
            logger.error("\u5207\u6362\u5230Sftp\u76ee\u5f55\u5f02\u5e38", new Object[]{e.getCause().getMessage()});
        }
        try {
            sftp.disconnect();
            this.clear(sftp.getSession());
        }
        catch (JSchException e) {
            logger.error("\u5173\u95edSFTP\u8fde\u63a5\u51fa\u9519", (Throwable)e);
        }
    }

    private void clear(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
    }

    public static String getFtpCert() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("ftp_cert_path", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            return null;
        }
        CipherInfo cipherInfo = OverseaSFTPUtils.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return OverseaSFTPUtils.getKey(fileContent);
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }

    private String getFtpCertPath() {
        EBContext context = EBContext.getContext();
        String customID = context.getCustomID();
        String storageRootPath = System.getProperty("user.dir");
        this.checkAndCreatePath(storageRootPath + File.separator + "cert" + File.separator + customID);
        return storageRootPath + File.separator + "cert" + File.separator + customID;
    }

    private void checkAndCreatePath(String path) {
        File file = FileCommonUtils.getFileByPath((String)path);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u521b\u5efa\u8def\u5f84: %s\u53d1\u751f\u5f02\u5e38\u3002", (String)"OverseaSFTPUtils_2", (String)"ebg-aqap-proxy", (Object[])new Object[0]), path), (Throwable)e);
            }
        }
    }

    public static List<String> lsFile(ChannelSftp sftp, String file) throws Exception {
        ArrayList<String> list = new ArrayList<String>(10);
        Vector vv = sftp.ls(file);
        if (vv != null) {
            for (int ii = 0; ii < vv.size(); ++ii) {
                ChannelSftp.LsEntry entry;
                Object obj = vv.elementAt(ii);
                if (!(obj instanceof ChannelSftp.LsEntry) || (entry = (ChannelSftp.LsEntry)obj).getAttrs().isDir()) continue;
                list.add(entry.getFilename());
            }
        }
        return list;
    }

    public String parseFormat(String ftpPath) {
        int index = ftpPath.indexOf("${");
        int index2 = ftpPath.indexOf("}");
        if (index == -1 || index2 == -1) {
            return ftpPath;
        }
        String head = ftpPath.substring(0, index);
        String content = ftpPath.substring(index + 2, index2);
        String tail = ftpPath.substring(index2 + 1);
        try {
            int dtIndex;
            int dIndex = content.indexOf("d'");
            if (dIndex != -1) {
                String dHead = content.substring(0, dIndex);
                String dContent = content.substring(dIndex + 2);
                int dIndex2 = dContent.lastIndexOf("'");
                if (dIndex2 == -1) {
                    logger.info("\u52a8\u6001\u89e3\u6790\u5185\u5bb9\u4e0d\u7b26\u5408\u89c4\u5219\uff1a{}\u3002", (Object)ftpPath);
                    return ftpPath;
                }
                String dTail = dContent.substring(dIndex2 + 1);
                dContent = dContent.substring(0, dIndex2);
                dContent = LocalDate.now().format(DateTimeFormatter.ofPattern(dContent));
                content = dHead + dContent + dTail;
            }
            if ((dtIndex = content.indexOf("dt'")) != -1) {
                String dHead = content.substring(0, dtIndex);
                String dContent = content.substring(dtIndex + 3);
                int dIndex2 = dContent.lastIndexOf("'");
                if (dIndex2 == -1) {
                    logger.info("\u52a8\u6001\u89e3\u6790\u5185\u5bb9\u4e0d\u7b26\u5408\u89c4\u5219\uff1a{}\u3002", (Object)ftpPath);
                    return ftpPath;
                }
                String dTail = dContent.substring(dIndex2 + 1);
                dContent = dContent.substring(0, dIndex2);
                dContent = LocalDateTime.now().format(DateTimeFormatter.ofPattern(dContent));
                content = dHead + dContent + dTail;
            }
            return head + content + tail;
        }
        catch (Exception e) {
            logger.info("\u52a8\u6001\u89e3\u6790\u51fa\u73b0\u5f02\u5e38,\u8fd4\u56de\u539f\u8def\u5f84\uff1a{}\u3002", (Object)ftpPath);
            return ftpPath;
        }
    }
}

