/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.proxy.oversea.utils.FileContentWriterUtil;
import kd.ebg.aqap.proxy.oversea.utils.OverseaSFTPUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;

public class SSHDSftpUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SSHDSftpUtil.class);
    private static SSHDSftpUtil instance = null;

    public static synchronized SSHDSftpUtil getInstance() {
        if (instance == null) {
            instance = new SSHDSftpUtil();
        }
        return instance;
    }

    private SSHDSftpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadAllFiles(String desFileDir) {
        String is_need_delete_file = null;
        Map runningParams = EBContext.getContext().getRunningParams();
        if (!CollectionUtils.isEmpty((Map)runningParams)) {
            is_need_delete_file = (String)EBContext.getContext().getRunningParams().get("is_need_delete_file");
        }
        boolean need_delete_file = Boolean.parseBoolean(is_need_delete_file);
        String sftpDownloadPath = RequestContextUtils.getBankParameterValue((String)"ftp_download_path");
        SshClient sshClient = this.getSSHClient();
        try (ClientSession session = this.connect(sshClient);){
            SftpClientFactory factory = SftpClientFactory.instance();
            try (SftpClient sftp = factory.createSftpClient(session);){
                Iterable dirEntries = sftp.readDir(sftpDownloadPath);
                int count = 0;
                for (SftpClient.DirEntry entry : dirEntries) {
                    boolean isDirectory = entry.getAttributes().isDirectory();
                    if (isDirectory) continue;
                    try (InputStream read = sftp.read(entry.getFilename(), new SftpClient.OpenMode[]{SftpClient.OpenMode.Read});){
                        Path resolve = Paths.get(desFileDir + File.separator + entry.getFilename(), new String[0]);
                        Files.copy(read, resolve, StandardCopyOption.REPLACE_EXISTING);
                        ++count;
                    }
                    if (!need_delete_file) continue;
                    String path = sftpDownloadPath;
                    if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                    try {
                        sftp.remove(path + entry.getFilename());
                    }
                    catch (Exception e) {
                        logger.error("\u5220\u9664sftp\u4e0a\u6587\u4ef6\uff1a" + entry.getFilename() + "\u5931\u8d25,\u5ffd\u7565\u6b64\u6b65", (Throwable)e);
                    }
                }
                logger.info("SFTP\u8def\u5f84\u4e3a\uff1a" + sftpDownloadPath + "\uff0c\u6210\u529f\u4e0b\u8f7d\u5230\u6587\u4ef6\u6570\uff1a" + count);
            }
        }
        catch (IOException e) {
            logger.error("\u4ece\u94f6\u884csftp\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (sshClient != null) {
                sshClient.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(String uploadFilePath) {
        SshClient sshClient = this.getSSHClient();
        try {
            boolean bl = this.upload(uploadFilePath, sshClient);
            return bl;
        }
        finally {
            if (sshClient != null) {
                sshClient.stop();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean upload(String uploadFilePath, SshClient sshClient) {
        try (ClientSession session = this.connect(sshClient);){
            boolean bl = this.upload(Paths.get(uploadFilePath, new String[0]), session);
            return bl;
        }
        catch (IOException e) {
            logger.error("\u5efa\u7acbsftp\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean upload(Path uploadFilePath, ClientSession session) {
        SftpClientFactory factory = SftpClientFactory.instance();
        try (SftpClient sftp = factory.createSftpClient(session);){
            EBContext context = EBContext.getContext();
            IParameter parameter = context.getParameter();
            String sftpUploadPath = parameter.getBankParameter("ftp_upload_path");
            sftp.put(uploadFilePath, sftpUploadPath + "/" + uploadFilePath.getFileName());
            logger.info("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f!");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    public ClientSession connect(SshClient client) throws IOException {
        String ftpCert;
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String sftpIP = parameter.getBankParameter("ip");
        String sftpPortStr = parameter.getBankParameter("exchangePort");
        String sftpCertPath = parameter.getBankParameter("ftp_cert_path");
        String sftpUserName = parameter.getBankParameter("ftp_user_name");
        String sftpPassword = parameter.getBankParameter("ftp_password");
        String sftpCertPassword = parameter.getBankParameter("ftp_cert_password");
        int sftpPort = Integer.parseInt(sftpPortStr);
        ClientSession session = (ClientSession)((ConnectFuture)client.connect(sftpUserName, sftpIP, sftpPort).verify(5000L)).getSession();
        if (StringUtils.isNotEmpty((String)sftpPassword)) {
            session.addPasswordIdentity(sftpPassword);
        }
        if (StringUtils.isNotEmpty((String)sftpCertPath) && StringUtils.isNotEmpty((String)(ftpCert = OverseaSFTPUtils.getFtpCert()))) {
            Path certPath;
            String parentPath = System.getProperty("user.dir") + File.separator + "cert" + File.separator + context.getCustomID();
            Path path = Paths.get(parentPath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            if (!Files.exists(certPath = Paths.get(parentPath + File.separator + sftpCertPath, new String[0]), new LinkOption[0])) {
                logger.info("\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u4fdd\u5b58\u8bc1\u4e66\u5185\u5bb9\u5230\u5bf9\u5e94\u76ee\u5f55:" + certPath);
                FileContentWriterUtil.writeUTF8FileContent(certPath.toString(), ftpCert);
                if (Files.exists(certPath, new LinkOption[0])) {
                    logger.info("\u8bc1\u4e66\u4fdd\u5b58\u6210\u529f");
                }
            }
            FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(certPath);
            session.setKeyIdentityProvider((KeyIdentityProvider)fileKeyPairProvider);
        }
        session.auth().verify(5000L);
        return session;
    }

    public SshClient getSSHClient() {
        SshClient client = SshClient.setUpDefaultClient();
        client.start();
        return client;
    }
}

