/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.swift.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.ebg.aqap.proxy.swift.model.SwiftBlock;
import kd.ebg.egf.common.log.EBGLogger;

public final class SwiftBasicHeaderBlock
extends SwiftBlock {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SwiftBasicHeaderBlock.class);
    public static final String BLOCKTYPE = "1:";
    private String applicationIdentifier = "";
    private String serviceIdentifier = "";
    private String logicalTerminal = "";
    private String sessionNumber = "";
    private String sequenceNumber = "";

    public String getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    public String getServiceIdentifier() {
        return this.serviceIdentifier;
    }

    public String getLogicalTerminal() {
        return this.logicalTerminal;
    }

    public String getSessionNumber() {
        return this.sessionNumber;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String toString() {
        return "Block1{applicationIdentifier='" + this.applicationIdentifier + '\'' + ", serviceIdentifier='" + this.serviceIdentifier + '\'' + ", logicalTerminal='" + this.logicalTerminal + '\'' + ", sessionNumber='" + this.sessionNumber + '\'' + ", sequenceNumber='" + this.sequenceNumber + '\'' + '}';
    }

    @Override
    public void parserText() {
        String regex = "\\{1:(\\w)(\\d{2})(\\w{12})(\\d{6})(\\d{4})}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(this.unParserText);
        if (matcher.matches()) {
            this.applicationIdentifier = matcher.group(1);
            this.serviceIdentifier = matcher.group(2);
            this.logicalTerminal = matcher.group(3);
            this.sessionNumber = matcher.group(4);
            this.sequenceNumber = matcher.group(5);
        } else {
            logger.info("\u5934\u90e8\u4fe1\u606f\u57571\u7684\u683c\u5f0f\u6709\u8bef\uff1a{}\u3002", (Object)this.unParserText);
        }
    }
}

