/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjhxb.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Packer;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Parser;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Util;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        String accNo = bankBalanceRequest.getAcnt().getAccNo();
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)FJHXB_Packer.buildHead("B2EActBalQry", Sequence.gen18Sequence()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        Element Map = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)Map, (String)"Currency", (String)bankBalanceRequest.getBankCurrency());
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = FJHXB_Parser.parserCommonInfo(root);
        if (!FJHXB_Util.SUCCESS_CODE.equalsIgnoreCase(bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        List list = root.getChild("Body").getChild("List").getChildren("Map");
        Element Map = (Element)list.get(0);
        BalanceInfo balanceInfo = new BalanceInfo();
        String currency = JDomUtils.getChildText((Element)Map, (String)"Currency");
        balanceInfo.setBankCurrency(currency);
        this.setBankAcnt(balanceInfo, bankBalanceRequest.getAcnt());
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        this.setCurrentBalance(balanceInfo, Map.getChildText("Balance"));
        this.setAvailableBalance(balanceInfo, Map.getChildText("AvailBal"));
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ebBankBalanceResponse.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        return ebBankBalanceResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EActBalQry";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/B2EActBalQry.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=2";
        factory.setUri(s);
        super.configFactory(factory);
    }
}

