/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.balance;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayDepositBalBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DepositBalanceImpl
extends AbstractBalanceImpl
implements ITodayDepositBalBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = Packer.createMessageWithHead("SignUpActFincDetailB2e");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        String reqAccNo = ((BankAcnt)bankBalanceRequest.getBankAcntList().get(0)).getAccNo();
        JDomUtils.addChild((Element)xdataBody, (String)"AcNo", (String)reqAccNo);
        JDomUtils.addChild((Element)xdataBody, (String)"Currency", (String)bankBalanceRequest.getBankCurrency());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseResponse(root);
        ParserUtils.checkRspCode((BankAcnt)((BankAcnt)bankBalanceRequest.getBankAcntList().get(0)), (String)ResManager.loadKDString((String)"\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2", (String)"DepositBalanceImpl_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (BankResponse)response, (String)"0");
        Element xDataBody = root.getChild("xDataBody");
        Element List2 = JDomUtils.getChildElement((Element)xDataBody, (String)"List");
        List Map2 = List2.getChildren("Map");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        if (!Map2.isEmpty()) {
            balanceInfos = new ArrayList(Map2.size());
        }
        for (Element item : Map2) {
            String AcNo = item.getChildText("AcNo");
            String CurCode = item.getChildText("CurCode");
            String UppAmt = item.getChildText("UppAmt");
            BalanceInfo balanceInfo = new BalanceInfo();
            BankAcnt acnt = new BankAcnt();
            acnt.setAccNo(AcNo);
            if (StringUtils.isNotEmpty((String)CurCode) && CurrencyUtils.isISOCurrency((String)CurCode)) {
                CurCode = CurrencyUtils.convert2Bank((String)CurCode);
            }
            BalanceUtil.setBankAcnt((BalanceInfo)balanceInfo, (BankAcnt)acnt);
            BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)CurCode);
            BalanceUtil.setDepositBalance((BalanceInfo)balanceInfo, (String)UppAmt);
            balanceInfos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public boolean match(BankBalanceRequest request) {
        LocalDate today = LocalDate.now();
        boolean matchTime = today.equals(request.getStartDate()) && today.equals(request.getEndDate());
        boolean matchConfig = BankBusinessConfig.isQueryDepositBal(((BankAcnt)request.getBankAcntList().get(0)).getAccNo());
        return matchTime && matchConfig;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "SignUpActFincDetailB2e";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2", (String)"DepositBalanceImpl_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getURL());
    }
}

