/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Constants;
import kd.ebg.aqap.banks.cmbc.dc.services.DateHelper;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class NewDetailParser
implements Constants {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(NewDetailParser.class);
    private static int ROWNUM = 13;
    private static int ROWNUM_F = 14;

    public static List<DetailInfo> parseTodayDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        if (BankBusinessConfig.isVirtualAccount(rqst.getAcnt().getAccNo())) {
            return NewDetailParser.parseVirtualDetail(rqst, rspStr);
        }
        return NewDetailParser.parseDetail(rqst, rspStr);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        void var2_4;
        ArrayList arrayList = new ArrayList(16);
        BankAcnt bankAcnt = rqst.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse bankResponse = Parser.parseResponse(root);
        if (!"0".equalsIgnoreCase(bankResponse.getResponseCode())) {
            if ("E4014".equalsIgnoreCase(bankResponse.getResponseCode()) && PropertiesConstants.getValue((String)"ERROR_NOT_RECORD").equalsIgnoreCase(bankResponse.getResponseMessage())) {
                log.info("\u67e5\u8be2\u6b64\u65e5\u671f\u671f\u95f4\u65e0\u660e\u7ec6\u6216\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u3002");
                return var2_4;
            }
            if ("E6002".equalsIgnoreCase(bankResponse.getResponseCode())) {
                bankResponse.setResponseMessage(String.format(ResManager.loadKDString((String)"%s\u7531\u4e8e\u94f6\u884c\u63a5\u53e3\u9650\u5236\u5982\u679c\u67e5\u8be2\u65e5\u671f\u5305\u542b\u5f53\u65e5\u548c\u5386\u53f2\u65e5\u671f\u65f6\u95f4\u6bb5\u5219\u62a5\u9519\u30021.\u8bf7\u67e5\u8be2\u65f6\u53ea\u9009\u62e9\u5386\u53f2\u65f6\u95f4\u6bb5\u6216\u4ec5\u5f53\u65e5\u65f6\u95f4\u8fdb\u884c\u67e5\u8be2\u30022.\u95f4\u969410\u5206\u949f\u540e\u518d\u6b21\u67e5\u8be2\u3002", (String)"NewDetailParser_5", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
            }
            EBServiceException ex = new EBServiceException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a:%1$s,%2$s", (String)"NewDetailParser_6", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
            log.error(ex.getMessage());
            throw ex;
        }
        Element xdatabody = root.getChild("xDataBody");
        String totalnum = ParserUtils.checkUnNullableElement((Element)xdatabody, (String)"totalNum");
        String dataStr = JDomUtils.getChildText((Element)xdatabody, (String)"dataStream");
        if (null == totalnum) return new ArrayList<DetailInfo>(16);
        if ("".equalsIgnoreCase(totalnum)) return new ArrayList<DetailInfo>(16);
        if ("".equalsIgnoreCase(dataStr)) {
            return new ArrayList<DetailInfo>(16);
        }
        List<DetailInfo> list = NewDetailParser.parseDataString(rqst, StringUtils.split((String)dataStr, (String)"|"), ROWNUM);
        return var2_4;
    }

    public static List<DetailInfo> parseDataString(BankDetailRequest rqst, String[] datas, int rowNum) {
        Boolean flag_fourteen = NewDetailParser.isContainChinese(datas[13]);
        rowNum = flag_fourteen != false ? ROWNUM_F : ROWNUM;
        ArrayList<DetailInfo> results = new ArrayList<DetailInfo>(16);
        int i = 0;
        if (datas[0].contains(PropertiesConstants.getValue((String)"DEAL"))) {
            i = 1;
        }
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        while (i < datas.length / rowNum) {
            String transDateStr;
            LocalDateTime parseLocalDateTime;
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccNo(rqst.getAcnt().getAccNo());
            detailInfo.setAccName(rqst.getAcnt().getAccName());
            detailInfo.setCurrency(rqst.getBankCurrency());
            if (StringUtils.isNotEmpty((String)datas[rowNum * i + 4])) {
                detailInfo.setBalance(new BigDecimal(datas[rowNum * i + 4]));
            }
            detailInfo.setDebitAmount(new BigDecimal(datas[rowNum * i + 2]));
            detailInfo.setCreditAmount(new BigDecimal(datas[rowNum * i + 3]));
            String explanation = datas[i * rowNum + 7];
            detailInfo.setExplanation(explanation);
            String timeFormat = "yyyyMMddHHmmss";
            if (flag_fourteen.booleanValue()) {
                detailInfo.setOppAccName(datas[i * rowNum + 11]);
                detailInfo.setOppAccNo(datas[i * rowNum + 10]);
                detailInfo.setOppBankName(datas[i * rowNum + 12]);
                parseLocalDateTime = DateHelper.parse(datas[i * rowNum + 13].trim().split("\\.")[0], timeFormat);
                transDateStr = datas[i * rowNum + 13].substring(0, 8);
            } else {
                detailInfo.setOppAccName(datas[i * rowNum + 10]);
                detailInfo.setOppAccNo(datas[i * rowNum + 9]);
                detailInfo.setOppBankName(datas[i * rowNum + 11]);
                parseLocalDateTime = DateHelper.parse(datas[i * rowNum + 12].trim().split("\\.")[0], timeFormat);
                transDateStr = datas[i * rowNum + 12].substring(0, 8);
            }
            detailInfo.setTransTime(parseLocalDateTime);
            detailInfo.setTransDate(parseLocalDateTime.toLocalDate());
            String cdFlag = "1";
            String amount = "";
            String accNo = rqst.getAcnt().getAccNo();
            if (detailInfo.getDebitAmount().equals(PackerUtils.ZERO)) {
                cdFlag = "1";
                amount = detailInfo.getCreditAmount().toString();
            } else {
                cdFlag = "0";
                amount = detailInfo.getDebitAmount().toString();
            }
            String flowNo = datas[i * rowNum + 1];
            String serialNo = flowNo = flowNo.substring(0, flowNo.length() - 9);
            String bankDetailNo = datas[i * rowNum + 1];
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("serialNo", (Object)serialNo);
            jsonObject.put("cdFlag", (Object)cdFlag);
            jsonObject.put("Amount", (Object)amount);
            jsonObject.put("transDate", (Object)transDateStr);
            jsonObject.put("bankDetailNo", (Object)bankDetailNo);
            jsonObject.put("debitAmount", (Object)detailInfo.getDebitAmount());
            jsonObject.put("creditAmount", (Object)detailInfo.getCreditAmount());
            jsonObject.put("accNo", (Object)rqst.getAcnt().getAccNo());
            detailInfo.setJsonMap(jsonObject.toJSONString());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDateStr, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            DetailSysFiled.set((DetailInfo)detailInfo, (String)"bizRefNo", (String)datas[rowNum * i + 1]);
            detailInfo.setBankDetailNo(bankDetailNo);
            results.add(detailInfo);
            if (detailInfo.getCreditAmount().compareTo(PackerUtils.ZERO) == 0 && explanation.contains("_KD_")) {
                String KDRetFlag = BizNoUtil.getId((String)explanation);
                if (KDRetFlag.length() > 8) {
                    KDRetFlag = KDRetFlag.substring(KDRetFlag.length() - 8);
                }
                detailInfo.setPayBankDetailSeqID(KDRetFlag);
                String exp = BizNoUtil.getMsg((String)explanation);
                detailInfo.setExplanation(exp);
            }
            if (explanation.contains(PropertiesConstants.getValue((String)"STMTS_XJCZJSC"))) {
                detailInfo.markTransUp();
            } else if (explanation.contains(PropertiesConstants.getValue((String)"STMTS_XJCZJXB"))) {
                detailInfo.markTransDown();
            }
            ++i;
        }
        return results;
    }

    public static List<DetailInfo> parseVirtualDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        int size;
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse bankResponse = Parser.parseResponse(root);
        if (!"0".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBServiceException ex = new EBServiceException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a:%1$s,%2$s", (String)"NewDetailParser_6", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
            log.error(ex.getMessage());
            throw ex;
        }
        if (bankResponse.getResponseMessage().contains(PropertiesConstants.getValue((String)"NOT_RELATED_RECORD"))) {
            return new ArrayList<DetailInfo>(16);
        }
        Element xdatabody = root.getChild("xDataBody");
        String totalnum = ParserUtils.checkUnNullableElement((Element)xdatabody, (String)"recordNumber");
        Element dtlListElement = xdatabody.getChild("List");
        List dtlLists = dtlListElement.getChildren("Map");
        int totalnumInt = Integer.parseInt(totalnum);
        if (totalnumInt != (size = dtlLists.size())) {
            EBServiceException ex = new EBServiceException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25. \u8fd4\u56de\u62a5\u6587\u4e2d'\u63cf\u8ff0\u603b\u6761\u6570':%1$s\u548c'\u660e\u7ec6\u5217\u8868'\u6570\u76ee:%2$s\u4e0d\u4e00\u81f4.", (String)"NewDetailParser_7", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), totalnumInt, size));
            log.error(ex.getMessage());
            throw ex;
        }
        return NewDetailParser.parseEachDetails(rqst, dtlLists);
    }

    public static boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5\uff01\uff0c\u3002()\u300a\u300b\u201c\u201d\uff1f\uff1a\uff1b\u3010\u3011]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    private static List<DetailInfo> parseEachDetails(BankDetailRequest rqst, List dtlLists) throws EBServiceException {
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(16);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < dtlLists.size(); ++i) {
            Element dtlInfo = (Element)dtlLists.get(i);
            String TransDate = dtlInfo.getChildTextTrim("TransDate");
            String TransTime = dtlInfo.getChildTextTrim("TransTime");
            String accNo = rqst.getAcnt().getAccNo();
            String accName = rqst.getAcnt().getAccName();
            String LoanAmount = dtlInfo.getChildTextTrim("LoanAmount");
            String LendAmount = dtlInfo.getChildTextTrim("LendAmount");
            String opAcntNoStr = dtlInfo.getChildTextTrim("OppAcNo");
            String opAcntNameStr = dtlInfo.getChildTextTrim("OppAcName");
            String opBankNameStr = dtlInfo.getChildTextTrim("OppBankName");
            String subSerialNo = dtlInfo.getChildTextTrim("SubSerialNo");
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccName(accName);
            detailInfo.setAccNo(accNo);
            detailInfo.setOppAccName(opAcntNameStr);
            detailInfo.setOppAccNo(opAcntNoStr);
            detailInfo.setOppBankName(opBankNameStr);
            if (!LoanAmount.isEmpty()) {
                detailInfo.setDebitAmount(new BigDecimal(LoanAmount));
            } else {
                detailInfo.setDebitAmount(BigDecimal.valueOf(0.0));
            }
            if (!LendAmount.isEmpty()) {
                detailInfo.setCreditAmount(new BigDecimal(LendAmount));
            } else {
                detailInfo.setCreditAmount(BigDecimal.valueOf(0.0));
            }
            String explainStr = dtlInfo.getChildTextTrim("Remark");
            detailInfo.setExplanation(BizNoUtil.getMsgNullAsBlank((String)explainStr));
            String KDRetFlag = BizNoUtil.getIdNullAsBlank((String)explainStr);
            DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)KDRetFlag);
            String timeFormat = "yyyy-MM-dd HH:mm:ss";
            String timeStr = null;
            if (TransTime != null && TransTime.length() > 0) {
                if ((TransTime = TransTime.trim()).length() == 5) {
                    TransTime = "0" + TransTime;
                }
                timeStr = TransDate + " " + TransTime;
            } else {
                timeStr = TransDate + " 000000";
            }
            detailInfo.setTransDate(DateHelper.parse(timeStr, timeFormat).toLocalDate());
            detailInfo.setTransTime(DateHelper.parse(timeStr, timeFormat));
            detailInfo.setCurrency(rqst.getBankCurrency());
            String balStr = dtlInfo.getChildTextTrim("SelfBalance");
            if (!StringUtils.isEmpty((String)balStr)) {
                detailInfo.setBalance(new BigDecimal(balStr));
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("transDate", (Object)TransDate);
            jsonObject.put("bankDetailNo", (Object)subSerialNo);
            jsonObject.put("debitAmount", (Object)detailInfo.getDebitAmount());
            jsonObject.put("creditAmount", (Object)detailInfo.getCreditAmount());
            detailInfo.setJsonMap(jsonObject.toJSONString());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, TransDate, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            list.add(detailInfo);
        }
        return list;
    }
}

