/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.ClearCode;
import kd.ebg.aqap.banks.cmbc.dc.services.DateHelper;
import kd.ebg.aqap.banks.cmbc.dc.services.ExplanationUtil;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentPacker {
    public static String packPayMsg(PaymentInfo paymentInfo, String tranCode, String oppAcntType) throws EBServiceException {
        Element root = Packer.createMessageWithHead(tranCode);
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)xdataBody, (String)"acntNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"acntName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"acntToNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"acntToName", (String)paymentInfo.getIncomeAccName());
        String sameBank = paymentInfo.is2SameBank() ? "0" : "1";
        JDomUtils.addChild((Element)xdataBody, (String)"externBank", (String)sameBank);
        String localFlagStr = PaymentPacker.getLocalFlag4Pay(paymentInfo);
        JDomUtils.addChild((Element)xdataBody, (String)"localFlag", (String)localFlagStr);
        JDomUtils.addChild((Element)xdataBody, (String)"rcvCustType", (String)oppAcntType);
        if (!paymentInfo.is2SameBank()) {
            String bankCnapCode;
            String incomeCnaps = paymentInfo.getIncomeCnaps();
            String incomeBankName = paymentInfo.getIncomeBankName();
            if (BankBusinessConfig.isCyberFlag() && "5".equalsIgnoreCase(localFlagStr) && !StringUtils.isEmpty((String)(bankCnapCode = ClearCode.instance().getBackConpAndName(paymentInfo))) && bankCnapCode.indexOf("@_") != -1) {
                incomeCnaps = bankCnapCode.split("@_")[0];
                incomeBankName = bankCnapCode.split("@_")[1];
            }
            JDomUtils.addChild((Element)xdataBody, (String)"bankCode", (String)incomeCnaps);
            JDomUtils.addChild((Element)xdataBody, (String)"bankName", (String)incomeBankName);
        } else {
            JDomUtils.addChild((Element)xdataBody, (String)"bankName", (String)paymentInfo.getIncomeBankName());
        }
        JDomUtils.addChild((Element)xdataBody, (String)"bankAddr", (String)paymentInfo.getIncomeBankAddress());
        BigDecimal amt = paymentInfo.getAmount().setScale(2, 4);
        JDomUtils.addChild((Element)xdataBody, (String)"amount", (String)amt.toString());
        String exp = PaymentPacker.getExplain(paymentInfo, tranCode, oppAcntType);
        if (!StringUtils.isEmpty((String)exp) && exp.length() > 50) {
            exp = exp.substring(0, 50);
        }
        JDomUtils.addChild((Element)xdataBody, (String)"explain", (String)exp);
        LocalDateTime bookingDate = paymentInfo.getBookingTime();
        if (bookingDate == null || bookingDate.isBefore(LocalDateTime.now())) {
            bookingDate = LocalDateTime.now();
        }
        JDomUtils.addChild((Element)xdataBody, (String)"actDate", (String)DateHelper.formatDate(bookingDate.toLocalDate()));
        PaymentUtil.setBookPayFlag((PaymentInfo)paymentInfo);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String getLocalFlag4Pay(PaymentInfo pay) {
        String payerCity = pay.getAccCity();
        String payeeCity = pay.getIncomeCity();
        if (pay.is2SameBank()) {
            if (payeeCity.contains(PropertiesConstants.getValue((String)"BEIJING"))) {
                return "1";
            }
            return pay.is2SameCity() ? "0" : "1";
        }
        BigDecimal amount = pay.getAmount().setScale(2, 4);
        String backConpAndName = ClearCode.instance().getBackConpAndName(pay);
        if (BankBusinessConfig.isCyberFlag() && !StringUtils.isEmpty((String)backConpAndName)) {
            return amount.compareTo(new BigDecimal("1000000.00")) < 0 ? "5" : "3";
        }
        return amount.compareTo(new BigDecimal("1000000.00")) < 0 ? "2" : "3";
    }

    private static boolean isShangHaiCity(String payerCity, String payeeCity) {
        return payerCity.contains(PropertiesConstants.getValue((String)"SHANGHAI")) || payeeCity.contains(PropertiesConstants.getValue((String)"SHANGHAI"));
    }

    public static String getExplain(PaymentInfo paymentInfo, String tranCode, String oppAcntType) {
        String exp = ExplanationUtil.getExpOrAbs(paymentInfo);
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            exp = BizNoUtil.cont((String)paymentInfo.getBankDetailSeqId(), (String)exp);
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
        }
        String use = UseKeyWordService.getUseByKey((String)EBContext.getContext().getCustomID(), (String)paymentInfo.getExplanation(), (String)"CostReimb", (String)"", (String)paymentInfo.getBankVersionID());
        if ("Xfer".equals(tranCode)) {
            if ("2".equalsIgnoreCase(oppAcntType)) {
                exp = use + "|" + exp;
            }
        } else if ("2".equalsIgnoreCase(oppAcntType) && !paymentInfo.is2SameBank()) {
            exp = use + "|" + exp;
        } else if (!"1".equals(oppAcntType)) {
            exp = use;
        }
        return exp;
    }
}

