/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scbsg.h2h.services.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractMT942Handler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SCBSG_H2H_CAMT052_Handler
extends AbstractMT942Handler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SCBSG_H2H_CAMT052_Handler.class);

    public void processFile(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        try {
            if (this.isTodayDetail(file.getName())) {
                this.processTodayDetail(file, detailInfoList, payInfoList, balanceInfoList);
            } else if (this.isBalance(file.getName())) {
                this.processTodayBalance(file, balanceInfoList);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u62a5\u544a[%1$s]\u51fa\u9519\u3002", (String)"SCBSG_H2H_CAMT052_Handler_1", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), file.getName()), (Throwable)e);
        }
    }

    private void processTodayBalance(File file, List<OverseaBalance> balanceInfoList) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            try (BufferedReader reader = new BufferedReader(inputStreamReader);){
                String line = reader.readLine();
                if (line != null) {
                    String balanceDate;
                    String currentBalance;
                    line = line.replaceAll("\"", "");
                    String[] split = line.split(",", -1);
                    OverseaBalance balanceInfo = new OverseaBalance();
                    balanceInfo.setNumber(split[5]);
                    balanceInfo.setCurrency(split[6]);
                    String availableBalance = split[11];
                    if (StringUtils.isNotEmpty((String)availableBalance)) {
                        balanceInfo.setAvailableBalance(new BigDecimal(availableBalance));
                    }
                    if (StringUtils.isNotEmpty((String)(currentBalance = split[13]))) {
                        balanceInfo.setCurrentBalance(new BigDecimal(currentBalance));
                    }
                    if (StringUtils.isEmpty((String)(balanceDate = split[8]))) {
                        balanceDate = split[7];
                    }
                    balanceInfo.setBalanceDate(LocalDate.parse(balanceDate, DateTimeFormatter.ofPattern("dd/MM/yyyy")).atStartOfDay());
                    balanceInfo.setUpdateSource(file.getName());
                    balanceInfo.setBankVersion(this.context.getBankVersionID());
                    balanceInfoList.add(balanceInfo);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u4f59\u989d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        this.logger.info("\u4ece\u4f59\u989d\u6587\u4ef6\u89e3\u6790\u51fa\u4f59\u989d\u8bb0\u5f55\u7b14\u6570:", (Object)balanceInfoList.size());
    }

    private void processTodayDetail(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) throws Exception {
        Element root = this.getRootFromFile(file, "UTF-8");
        Namespace ns = root.getNamespace();
        Element bkToCstmrAcctRpt = root.getChild("BkToCstmrAcctRpt", ns);
        List rptList = bkToCstmrAcctRpt.getChildren("Rpt", ns);
        for (Element rpt : rptList) {
            Element acct = rpt.getChild("Acct", ns);
            Element id = acct.getChild("Id", ns);
            Element othr = id.getChild("Othr", ns);
            String acntNumber = othr.getChildText("Id", ns);
            List list = rpt.getChildren("Ntry", ns);
            for (Element Ntry : list) {
                OverseaDetail detail = new OverseaDetail();
                Element amt = Ntry.getChild("Amt", ns);
                String amtText = amt.getText();
                String ccy = amt.getAttributeValue("Ccy");
                String cdtDbtInd = Ntry.getChildText("CdtDbtInd", ns);
                Element valDt = Ntry.getChild("ValDt", ns);
                detail.setTxDate(LocalDate.parse(valDt.getChildText("Dt", ns), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                detail.setNumber(acntNumber);
                detail.setPayBankName(this.context.getBankVersionID());
                detail.setPayBankVersion(this.context.getBankVersionID());
                detail.setDetailFileName(file.getName());
                detail.setCreatetime(LocalDateTime.now());
                detail.setCustomId(EBContext.getContext().getCustomID());
                detail.setCurrency(ccy);
                detail.setTxAmt(new BigDecimal(amtText));
                if ("DBIT".equalsIgnoreCase(cdtDbtInd)) {
                    detail.setCordFlag("DEBIT");
                } else if ("CRDT".equalsIgnoreCase(cdtDbtInd)) {
                    detail.setCordFlag("CREDIT");
                } else {
                    this.logger.info(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u786e\u5b9a\u501f\u8d37\u6807\u5fd7[%1$s]\u6240\u5c5e\u7684\u7c7b\u578b,\u65e0\u6cd5\u8bbe\u7f6e\u91d1\u989d\u501f\u8d37\u65b9\u5411\u3002", (String)"SCBSG_H2H_CAMT052_Handler_2", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), cdtDbtInd));
                }
                Element ntryDtls = Ntry.getChild("NtryDtls", ns);
                Element txDtls = ntryDtls.getChild("TxDtls", ns);
                Element rmtInf = txDtls.getChild("RmtInf", ns);
                List ustrd = rmtInf.getChildren("Ustrd", ns);
                if (CollectionUtil.isNotEmpty((Collection)ustrd)) {
                    StringBuilder sb = new StringBuilder();
                    for (Element element : ustrd) {
                        sb.append(element.getText()).append(",");
                    }
                    String explain = sb.substring(0, sb.length() - 1);
                    if (explain.length() > 500) {
                        explain = explain.substring(0, 500);
                    }
                    detail.setExplanation(explain);
                }
                detailInfoList.add(detail);
            }
        }
    }

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return this.isTodayDetail(fileName) || this.isBalance(fileName);
    }

    private boolean isBalance(String fileName) {
        return fileName.contains("H2H-MEC-ACBQ") || fileName.contains("H2H-501-AERQ.csv") || fileName.contains("REPORTSCUST") && fileName.contains(".txn");
    }

    private boolean isTodayDetail(String fileName) {
        return fileName.contains("CAMT052") || fileName.contains("CAMT52");
    }
}

