/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.ecny.service.payment.company;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterprisePayDcioexchRequestV1;
import com.icbc.api.response.MybankEnterprisePayDcioexchResponseV1;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.ecny.service.payment.company.PayPacker;
import kd.ebg.aqap.banks.icbc.ecny.service.payment.company.PayParser;
import kd.ebg.aqap.banks.icbc.ecny.service.payment.company.QueryPayImpl;
import kd.ebg.aqap.banks.icbc.ecny.service.util.GetStore;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import net.sf.json.JSONObject;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "DCIOEXCH";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6570\u5e01\u5145\u503c\u63d0\u73b0", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]);
    }

    public EBBankPayResponse pay(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "mybank/enterprise/pay/dcioexch/V1";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterprisePayDcioexchRequestV1.MybankEnterprisePayDcioexchRequestBizV1 bizContent = PayPacker.packer(paymentInfos);
            MybankEnterprisePayDcioexchRequestV1 request = new MybankEnterprisePayDcioexchRequestV1();
            request.setServiceUrl(BASE_URL + URI);
            request.setBizContent((BizContent)bizContent);
            logger.info("\u4ed8\u6b3e\u63d0\u4ea4\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)request).toString());
            try {
                MybankEnterprisePayDcioexchResponseV1 response = (MybankEnterprisePayDcioexchResponseV1)client.execute((IcbcRequest)request);
                logger.info("\u4ed8\u6b3e\u63d0\u4ea4\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                PayParser.parse(paymentInfos, response);
            }
            catch (Throwable t) {
                logger.error(t.getMessage());
                EBContext.getContext().setThrowableAfterSend(t);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

