/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.ecny.service.payment.etoe;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterprisePayQdcpayRequestV1;
import com.icbc.api.response.MybankEnterprisePayQdcpayResponseV1;
import kd.ebg.aqap.banks.icbc.ecny.service.payment.etoe.QueryPayPacker;
import kd.ebg.aqap.banks.icbc.ecny.service.payment.etoe.QueryPayParser;
import kd.ebg.aqap.banks.icbc.ecny.service.util.GetStore;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import net.sf.json.JSONObject;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "qdcpay";
    }

    public String getBizDesc() {
        return null;
    }

    public EBBankPayResponse queryPay(BankPayRequest req) {
        PaymentInfo[] paymentInfos = req.getPaymentInfoAsArray();
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "mybank/enterprise/pay/qdcpay/V1";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterprisePayQdcpayRequestV1.MybankEnterprisePayQdcpayRequestBizV1 bizContent = QueryPayPacker.packer(paymentInfos);
            MybankEnterprisePayQdcpayRequestV1 request = new MybankEnterprisePayQdcpayRequestV1();
            request.setServiceUrl(BASE_URL + URI);
            request.setBizContent((BizContent)bizContent);
            logger.info("\u540c\u6b65\u4ed8\u6b3e\u63d0\u4ea4\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)request).toString());
            MybankEnterprisePayQdcpayResponseV1 response = (MybankEnterprisePayQdcpayResponseV1)client.execute((IcbcRequest)request);
            logger.info("\u540c\u6b65\u4ed8\u6b3e\u63d0\u4ea4\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            QueryPayParser.parse(paymentInfos, response);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return new EBBankPayResponse(req.getPaymentInfos());
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

