/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.opa.service.apply;

import com.alibaba.fastjson.JSONArray;
import com.bocom.api.BocomRequest;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.StringUtils;
import kd.ebg.aqap.banks.bocom.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.opa.constants.ApplyStatus;
import kd.ebg.aqap.banks.bocom.opa.request.ApplyRequest;
import kd.ebg.aqap.banks.bocom.opa.response.ApplyResponse;
import kd.ebg.aqap.banks.bocom.opa.utils.BocomOpaUtil;
import kd.ebg.aqap.business.apply.atomic.AbstractQueryApplyImpl;
import kd.ebg.aqap.business.apply.atomic.IQueryApply;
import kd.ebg.aqap.business.apply.bank.BankQueryApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankQueryApplyResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class BocomOpaQueryApplyImpl
extends AbstractQueryApplyImpl
implements IQueryApply {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BocomOpaQueryApplyImpl.class);

    public EBBankQueryApplyResponse doBiz(BankQueryApplyRequest request) {
        if (this.canDoIt()) {
            try {
                ApplyResponse response = (ApplyResponse)BocomOpaUtil.send((BocomRequest)this.getRequest(request), this.getBizCode());
                return this.parse(request, response);
            }
            catch (Exception e) {
                this.logger.error("\u7b7e\u7ea6\u7533\u8bf7\u5931\u8d25", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u7b7e\u7ea6\u7ed3\u679c\u51fa\u73b0\u5f02\u5e38", (String)"BocomOpaQueryApplyImpl_0", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), (Throwable)e);
            }
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u9650\u6d41 \u8c03\u7528\u9891\u7387\u4e3a : %s\u6beb\u79d2", (String)"BocomOpaQueryApplyImpl_1", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), this.getInterval()));
    }

    private ApplyRequest getRequest(BankQueryApplyRequest bankQueryApplyRequest) {
        BankAcnt bankAcnt = bankQueryApplyRequest.getAcnt();
        ApplyRequest request = new ApplyRequest();
        ApplyRequest.ApplyRequestBiz.PpasBody ppasBody = new ApplyRequest.ApplyRequestBiz.PpasBody();
        ppasBody.setPlfmBsnId(BankBusinessConfig.getPlfmBsnID());
        ppasBody.setPlfmSerNo(bankQueryApplyRequest.getThirdVoucher());
        ppasBody.setOpType("3");
        ppasBody.setSignAcctNo(bankAcnt.getAccNo());
        ppasBody.setSignAcctNme(bankAcnt.getAccName());
        ApplyRequest.ApplyRequestBiz bizContent = new ApplyRequest.ApplyRequestBiz();
        bizContent.setPpasBody(ppasBody);
        bizContent.setPpasHead((ApplyRequest.ApplyRequestBiz.PpasHead)JSONArray.parseObject((String)BocomOpaUtil.getBizContentHead(), ApplyRequest.ApplyRequestBiz.PpasHead.class));
        request.setBizContent(bizContent);
        return request;
    }

    public EBBankQueryApplyResponse parse(BankQueryApplyRequest request, ApplyResponse response) {
        EBBankQueryApplyResponse result = new EBBankQueryApplyResponse();
        if ("F".equals(response.getBizState())) {
            result.setStatus(ApplyStatus.FAIL.getReturnType());
            result.setDesc(response.getRspMsg());
            result.setThirdVoucher(request.getThirdVoucher());
            return result;
        }
        if (response.getPpasHead() != null && !StringUtils.isEmpty((Object)response.getPpasHead().getReturnMsg())) {
            result.setStatus(ApplyStatus.FAIL.getReturnType());
            result.setDesc(response.getPpasHead().getReturnMsg());
            result.setThirdVoucher(request.getThirdVoucher());
            return result;
        }
        ApplyResponse.PpasBody body = response.getPpasBody();
        String status = "0";
        if (body != null) {
            status = body.getAthSts();
        }
        result.setThirdVoucher(request.getThirdVoucher());
        ApplyStatus applyStatus = ApplyStatus.getEnumDesc(status);
        result.setStatus(applyStatus.getReturnType());
        result.setDesc(applyStatus.getDesc());
        return result;
    }

    public String pack(BankQueryApplyRequest request) {
        return null;
    }

    public EBBankQueryApplyResponse parse(BankQueryApplyRequest request, String responseStr) {
        return null;
    }

    public String getDeveloper() {
        return "congmin_huang";
    }

    public String getBizCode() {
        return "/ppas/PPAS03001/";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7b7e\u7ea6\u7ed3\u679c\u67e5\u8be2", (String)"BocomOpaQueryApplyImpl_3", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]);
    }
}

