/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.opa.service.payment;

import com.alibaba.fastjson.JSONArray;
import com.bocom.api.BocomApiException;
import com.bocom.api.BocomRequest;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.opa.request.B2BYQFYQFU1001Request;
import kd.ebg.aqap.banks.bocom.opa.response.B2BYQFYQFU1001Response;
import kd.ebg.aqap.banks.bocom.opa.service.payment.B2BYQFYQFU1011Impl;
import kd.ebg.aqap.banks.bocom.opa.utils.BocomOpaUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class B2BYQFYQFU1001Impl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger LOG = EBGLogger.getInstance().getLogger(B2BYQFYQFU1001Impl.class);

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return B2BYQFYQFU1011Impl.class;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        if (this.canDoIt()) {
            try {
                B2BYQFYQFU1001Response resp = (B2BYQFYQFU1001Response)BocomOpaUtil.send((BocomRequest)this.getRequest(request), "/pptm/B2BYQFYQFU1001/");
                return this.parse(request, resp);
            }
            catch (BocomApiException e) {
                LOG.error(ResManager.loadKDString((String)"\u94f6\u4f01\u4ed8\u8ba2\u5355\u63d0\u4ea4\u51fa\u9519", (String)"B2BYQFYQFU1001Impl_0", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]));
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u9650\u6d41 \u8c03\u7528\u9891\u7387\u4e3a : %s\u6beb\u79d2", (String)"B2BYQFYQFU1001Impl_1", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), this.getInterval()));
    }

    private B2BYQFYQFU1001Request getRequest(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        B2BYQFYQFU1001Request b2BYQFYQFU1001Request = new B2BYQFYQFU1001Request();
        B2BYQFYQFU1001Request.B2BYQFYQFU1001RequestV1Biz bizContent = new B2BYQFYQFU1001Request.B2BYQFYQFU1001RequestV1Biz();
        B2BYQFYQFU1001Request.B2BYQFYQFU1001RequestV1Biz.PptmBody pptmBody = new B2BYQFYQFU1001Request.B2BYQFYQFU1001RequestV1Biz.PptmBody();
        bizContent.setPptmHead((B2BYQFYQFU1001Request.B2BYQFYQFU1001RequestV1Biz.PptmHead)JSONArray.parseObject((String)BocomOpaUtil.getBizContentHead(), B2BYQFYQFU1001Request.B2BYQFYQFU1001RequestV1Biz.PptmHead.class));
        bizContent.setPptmBody(pptmBody);
        pptmBody.setPlfmBsnId(BankBusinessConfig.getPlfmBsnID());
        pptmBody.setPlfmOrdrNo(paymentInfo.getBatchSeqID());
        pptmBody.setPlfmSerNo(paymentInfo.getDetailBizNo());
        pptmBody.setPayMthd("1");
        pptmBody.setOrdrTp("1");
        pptmBody.setOrdrAmt(paymentInfo.getAmount().toString());
        pptmBody.setCcy("CNY");
        pptmBody.setServFeeCrgAmt("0");
        pptmBody.setPayrAcctNo(paymentInfo.getAccNo());
        pptmBody.setPayrAcctNme(paymentInfo.getAccName());
        pptmBody.setPayrAcctTp("10");
        pptmBody.setRcvrAcctNo(paymentInfo.getIncomeAccNo());
        pptmBody.setRcvrAcctNme(paymentInfo.getIncomeAccName());
        pptmBody.setRcvrAcctTp("10");
        pptmBody.setRcvrActopeBankNo(paymentInfo.getIncomeCnaps());
        pptmBody.setRcvrActopeBankNme(paymentInfo.getIncomeBankName());
        String time = paymentInfo.getRequestTime().format(DateTimeFormatter.ofPattern("HHmmss"));
        String date = paymentInfo.getRequestTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String ot = BankBusinessConfig.getOtTrans();
        if (!StringUtils.isEmpty((String)ot)) {
            ot = paymentInfo.getRequestTime().plusSeconds(Long.parseLong(ot)).format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            pptmBody.setOrdrExpyTms(ot);
        }
        pptmBody.setTxnDt(date);
        pptmBody.setTxnTme(time);
        b2BYQFYQFU1001Request.setBizContent(bizContent);
        return b2BYQFYQFU1001Request;
    }

    public EBBankPayResponse parse(BankPayRequest request, B2BYQFYQFU1001Response response) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (response.isSuccess()) {
            B2BYQFYQFU1001Response.PptmBody pb = response.getPptmBody();
            B2BYQFYQFU1001Response.PptmHead ph = response.getPptmHead();
            String returnMsg = ph.getReturnMsg();
            String tranState = ph.getTranState();
            String txnSts = pb.getTxnSts();
            if (StringUtils.isEmpty((String)tranState) || "E".equalsIgnoreCase(tranState)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e86\u9519\u8bef\u4fe1\u606f:%s", (String)"B2BYQFYQFU1001Impl_3", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), returnMsg));
            }
            if (!BocomOpaUtil.txnStatus.containsKey(txnSts)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u72b6\u6001\u7801\uff1a%s", (String)"B2BYQFYQFU1001Impl_9", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), txnSts), (String)"", (String)txnSts);
                return new EBBankPayResponse(paymentInfos);
            }
            if ("01".equalsIgnoreCase(txnSts)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)BocomOpaUtil.txnStatus.get(txnSts), (String)"", (String)"");
            } else if ("00".equalsIgnoreCase(txnSts) || "05".equalsIgnoreCase(txnSts) || "07".equalsIgnoreCase(txnSts)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)BocomOpaUtil.txnStatus.get(txnSts), (String)"", (String)"");
            } else if ("02".equalsIgnoreCase(txnSts) || "08".equalsIgnoreCase(txnSts) || "09".equalsIgnoreCase(txnSts) || "10".equalsIgnoreCase(txnSts)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)BocomOpaUtil.txnStatus.get(txnSts), (String)"", (String)"");
            }
        } else {
            String bizState = response.getBizState();
            if ("F".equalsIgnoreCase(bizState)) {
                LOG.error(ResManager.loadKDString((String)"\u94f6\u4f01\u4ed8\u8ba2\u5355\u63d0\u4ea4\u51fa\u9519,\u54cd\u5e94\u4fe1\u606f\u4e3a\uff1a{}", (String)"B2BYQFYQFU1001Impl_5", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), new Object[]{((Object)((Object)response)).toString()});
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)response.getRspMsg(), (String)"", (String)"");
            } else if ("P".equalsIgnoreCase(bizState)) {
                LOG.error(ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u4ed8\u8ba2\u5355\u6b63\u5728\u5904\u7406\u4e2d,\u54cd\u5e94\u4fe1\u606f\u4e3a\uff1a{}", (String)"B2BYQFYQFU1001Impl_6", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), new Object[]{((Object)((Object)response)).toString()});
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)response.getRspMsg(), (String)"", (String)"");
            } else {
                LOG.error(ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u4ed8\u8ba2\u5355\u72b6\u6001\u672a\u77e5,\u54cd\u5e94\u4fe1\u606f\u4e3a\uff1a{}", (String)"B2BYQFYQFU1001Impl_7", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), new Object[]{((Object)((Object)response)).toString()});
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)response.getRspMsg(), (String)"", (String)"");
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return "cw";
    }

    public String getBizCode() {
        return "/pptm/B2BYQFYQFU1001/";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"1.6 B2B\u94f6\u4f01\u4ed8\u8ba2\u5355\u63d0\u4ea4", (String)"B2BYQFYQFU1001Impl_8", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }
}

