/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.opa.utils;

import com.alibaba.fastjson.JSON;
import com.bocom.api.BocomApiException;
import com.bocom.api.BocomRequest;
import com.bocom.api.BocomResponse;
import com.bocom.api.DefaultBocomClient;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.opa.BankBusinessConfig;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.utils.EBEnviromentUtil;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.CipherInfoUtil;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BocomOpaUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BocomOpaUtil.class);
    public static Map<String, String> txnStatus = new HashMap<String, String>(12);

    public static String getOpenMode(String bsnStr, String funType) {
        String[] modes;
        StringBuilder result = new StringBuilder("0000000000");
        if (StringUtils.isEmpty((String)bsnStr)) {
            return result.toString();
        }
        for (String fun : modes = bsnStr.split(",")) {
            if ("/pptm/B2BYQFYQFU1001/".equals(fun)) {
                result.replace(0, 1, funType);
                continue;
            }
            if ("/pptm/000000/".equals(fun)) {
                result.replace(1, 2, funType);
                continue;
            }
            if (!"/pptm/B2BYQFYQFU1016/".equals(fun)) continue;
            result.replace(2, 3, funType);
        }
        return result.toString();
    }

    public static BocomResponse send(BocomRequest request, String bizCode) throws BocomApiException {
        BocomResponse response;
        String appId = BankBusinessConfig.getAppId();
        String myPrivateKey = BocomOpaUtil.getPlateCertInfo("BOCOM_OPA", "plateForm_private_certInfo");
        String bankPublicKey = BocomOpaUtil.getPlateCertInfo("BOCOM_OPA", "plateForm_public_certInfo");
        String port = ":" + RequestContextUtils.getBankParameterValue((String)"exchangePort");
        if ("443".equals(port)) {
            port = "";
        }
        String uri = RequestContextUtils.getBankParameterValue((String)"exchangeUri");
        String url = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol") + "://" + RequestContextUtils.getBankParameterValue((String)"ip") + port + uri + bizCode + "v1";
        DefaultBocomClient client = new DefaultBocomClient(appId, myPrivateKey, bankPublicKey);
        request.setServiceUrl(url);
        if (!EBEnviromentUtil.isProduct()) {
            client.ignoreSSLHostnameVerifier();
        }
        try {
            logger.info("\u4ea4\u901a\u94f6\u884c\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSON((Object)request).toString());
            response = client.execute(request, UUID.randomUUID().toString().replace("-", ""));
            logger.info("\u4ea4\u901a\u94f6\u884c\u54cd\u5e94\u53c2\u6570\uff1a" + JSON.toJSON((Object)response).toString());
        }
        catch (BocomApiException exp) {
            logger.error("\u8bf7\u6c42\u4ea4\u901a\u94f6\u884c\u63a5\u53e3\u5f02\u5e38\uff1a" + (Object)((Object)exp));
            throw exp;
        }
        return response;
    }

    public static String getPlateCertInfo(String bankVersionId, String key) {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(bankVersionId, key);
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u94f6\u884c\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u94f6\u884c\u8bc1\u4e66", (String)"BocomOpaUtil_0", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String result = null;
        try {
            result = new String(fileContent, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("", (Throwable)e);
        }
        return result;
    }

    public static String genSeqId() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("KD").append(DateUtil.formatDateTime((Date)new Date()));
        for (int i = 0; i < 6; ++i) {
            Integer val = BocomOpaUtil.getInt();
            buffer.append(val.toString());
        }
        return buffer.toString();
    }

    private static Integer getInt() {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            return random.nextInt(10);
        }
        catch (NoSuchAlgorithmException e) {
            return 0;
        }
    }

    public static String getBizContentHead() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("struct", "json");
        map.put("country", "China");
        map.put("systemId", "KD_" + RequestContextUtils.getBankParameterValue((String)"app_id"));
        map.put("sendDate", DateUtil.formatTime4yyyyMMdd((Date)new Date()));
        map.put("sendTime", DateUtil.formatDate((Date)new Date(), (String)"HH:mm:ss"));
        map.put("timeZone", "GMT");
        map.put("language", "zh_CN");
        return JSON.toJSON(map).toString();
    }

    static {
        txnStatus.put("00", ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BocomOpaUtil_1", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]));
        txnStatus.put("01", ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"BocomOpaUtil_2", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]));
        txnStatus.put("02", ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"BocomOpaUtil_3", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]));
        txnStatus.put("05", ResManager.loadKDString((String)"\u63d0\u4ea4\u7ecf\u529e\u5f85\u786e\u8ba4", (String)"BocomOpaUtil_4", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]));
        txnStatus.put("07", ResManager.loadKDString((String)"\u7ecf\u529e\u5f85\u6388\u6743", (String)"BocomOpaUtil_5", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]));
        txnStatus.put("08", ResManager.loadKDString((String)"\u6388\u6743\u62d2\u7edd", (String)"BocomOpaUtil_6", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]));
        txnStatus.put("09", ResManager.loadKDString((String)"\u5df2\u8fc7\u671f", (String)"BocomOpaUtil_7", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]));
        txnStatus.put("10", ResManager.loadKDString((String)"\u5df2\u53d6\u6d88", (String)"BocomOpaUtil_8", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]));
    }
}

