/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.hkn.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.RateLimiter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.banks.dbs.hkn.services.DBS_DC_Packer;
import kd.ebg.aqap.banks.dbs.hkn.services.DBS_DC_Parser;
import kd.ebg.aqap.banks.dbs.hkn.services.utils.DbsHelper;
import kd.ebg.aqap.banks.dbs.hkn.services.utils.PgpHelper;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class HisDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(HisDetailImpl.class);
    private static final RateLimiter rateLimiter = RateLimiter.create((double)1.0, (long)1L, (TimeUnit)TimeUnit.SECONDS);

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        if (LocalDate.now().toEpochDay() - startDate.toEpochDay() > 30L) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u661f\u5c55\u94f6\u884c\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u5f00\u59cb\u65e5\u671f\u4e0e\u5f53\u524d\u65e5\u671f\u4e0d\u80fd\u8d85\u8fc730\u5929", (String)"HisDetailImpl_0", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]));
        }
        long days = 0L;
        if (!startDate.isEqual(endDate)) {
            days = endDate.toEpochDay() - startDate.toEpochDay();
        }
        ArrayList detailInfos = new ArrayList(100);
        int i = 0;
        while ((long)i <= days) {
            rateLimiter.acquire();
            EBBankDetailResponse ebBankDetailResponse = this.queryHis(request);
            if (ebBankDetailResponse != null && !CollectionUtils.isEmpty((Collection)ebBankDetailResponse.getDetails())) {
                detailInfos.addAll(ebBankDetailResponse.getDetails());
            }
            request.setStartDate(request.getStartDate().plusDays(1L));
            ++i;
        }
        return new EBBankDetailResponse(detailInfos);
    }

    private EBBankDetailResponse queryHis(BankDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        String s = DbsHelper.sendRequestAndReceive(RequestContextUtils.getBankParameterValue((String)"hisDetailUri"), acnt.getAccNo(), this.pack(request));
        return this.parse(request, s);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        JSONObject header = DBS_DC_Packer.createHeader(acnt.getAccNo(), acnt.getCountry());
        JSONObject txnInfo = new JSONObject();
        txnInfo.put("accountNo", (Object)acnt.getAccNo());
        txnInfo.put("accountCcy", (Object)bankDetailRequest.getBankCurrency());
        txnInfo.put("bizDate", (Object)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        txnInfo.put("messageType", (Object)"CAMT053JSON");
        JSONObject total = new JSONObject();
        total.put("header", (Object)header);
        total.put("txnInfo", (Object)txnInfo);
        try {
            return PgpHelper.encry(total.toJSONString());
        }
        catch (Throwable e) {
            this.logger.error("\u7b7e\u540d\u52a0\u5bc6\u53d1\u751f\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38", (String)"HisDetailImpl_1", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        String origin;
        try {
            origin = PgpHelper.decry(rspStr);
        }
        catch (Throwable e) {
            this.logger.error("\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38", (String)"HisDetailImpl_2", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]), (Throwable)e);
        }
        return this.parseInfo(origin, bankDetailRequest);
    }

    public EBBankDetailResponse parseInfo(String origin, BankDetailRequest bankDetailRequest) {
        JSONObject total = JSONObject.parseObject((String)origin);
        DBS_DC_Parser.checkError(total);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        JSONObject txnEnqResponse = total.getJSONObject("txnEnqResponse");
        String enqStatus = txnEnqResponse.getString("enqStatus");
        if (!"ACSP".equals(enqStatus)) {
            String enqStatusDescription = txnEnqResponse.getString("enqStatusDescription");
            if ("RJCT".equals(enqStatus) && "No statement available".equals(enqStatusDescription)) {
                return new EBBankDetailResponse(detailList);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,%1$s %2$s", (String)"HisDetailImpl_3", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]), enqStatus, enqStatusDescription));
        }
        JSONArray statements = txnEnqResponse.getJSONArray("statements");
        for (int j = 0; j < statements.size(); ++j) {
            JSONObject bkToCstmrStmt = statements.getJSONObject(j).getJSONObject("bkToCstmrStmt");
            JSONArray stmtList = bkToCstmrStmt.getJSONArray("stmt");
            for (int k = 0; k < stmtList.size(); ++k) {
                JSONObject stmt = stmtList.getJSONObject(k);
                BankAcnt acnt = bankDetailRequest.getAcnt();
                JSONArray ntryList = stmt.getJSONArray("ntry");
                if (ntryList == null || ntryList.size() == 0) {
                    return new EBBankDetailResponse(detailList);
                }
                for (int i = 0; i < ntryList.size(); ++i) {
                    JSONObject ntry = ntryList.getJSONObject(i);
                    DetailInfo info = new DetailInfo();
                    info.setAccNo(acnt.getAccNo());
                    info.setAccName(acnt.getAccName());
                    info.setBankName(acnt.getBankName());
                    JSONArray ntryDtlsArray = ntry.getJSONArray("ntryDtls");
                    JSONArray txDtlsArray = ntryDtlsArray.getJSONObject(0).getJSONArray("txDtls");
                    JSONObject rltdPties = txDtlsArray.getJSONObject(0).getJSONObject("rltdPties");
                    JSONObject amt = ntry.getJSONObject("amt");
                    info.setCurrency(amt.getString("ccy"));
                    String amount = amt.getString("value");
                    String cdFlag = ntry.getString("cdtDbtInd");
                    if ("DBIT".equals(cdFlag)) {
                        info.setDebitAmount(new BigDecimal(amount));
                        info.setCreditAmount(BigDecimal.ZERO);
                        if (rltdPties != null) {
                            JSONObject cdtrAcct;
                            JSONObject cdtr = rltdPties.getJSONObject("cdtr");
                            if (cdtr != null) {
                                info.setOppAccName(cdtr.getString("nm"));
                            }
                            if ((cdtrAcct = rltdPties.getJSONObject("cdtrAcct")) != null) {
                                info.setOppAccNo(cdtrAcct.getJSONObject("id").getJSONObject("othr").getString("id"));
                            }
                        }
                    } else if ("CRDT".equals(cdFlag)) {
                        JSONObject dbtr;
                        info.setDebitAmount(BigDecimal.ZERO);
                        info.setCreditAmount(new BigDecimal(amount));
                        if (rltdPties != null && (dbtr = rltdPties.getJSONObject("dbtr")) != null) {
                            info.setOppAccName(dbtr.getString("nm"));
                            JSONObject id = dbtr.getJSONObject("id");
                            if (id != null) {
                                info.setOppAccNo(id.getJSONObject("orgId").getJSONObject("othr").getString("id"));
                            }
                        }
                    }
                    String vt = ntry.getJSONObject("bookgDt").getString("dtTm");
                    try {
                        vt = vt.replaceAll(":", "");
                        LocalDateTime transTime = LocalDateTime.parse(vt, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssZ"));
                        info.setTransTime(transTime);
                        info.setTransDate(transTime.toLocalDate());
                    }
                    catch (Exception e) {
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\u89e3\u6790\u7684\u5b57\u6bb5\u4e3a\uff1a%s", (String)"HisDetailImpl_4", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]), vt), (Throwable)e);
                    }
                    info.setExplanation(ntry.getString("addtlNtryInf"));
                    detailList.add(info);
                }
            }
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CAMT053JSON";
    }

    public String getBizDesc() {
        return null;
    }
}

