/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.hkn.services.payment.inner;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.hkn.services.DBS_DC_Packer;
import kd.ebg.aqap.banks.dbs.hkn.services.DBS_DC_Parser;
import kd.ebg.aqap.banks.dbs.hkn.services.payment.querypay.QueryPayImpl;
import kd.ebg.aqap.banks.dbs.hkn.services.utils.DbsHelper;
import kd.ebg.aqap.banks.dbs.hkn.services.utils.PgpHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ACTPayImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ACTPayImpl.class);

    public EBBankPayResponse pay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String requestStr = this.pack(request);
        try {
            String response = DbsHelper.sendRequestAndReceive(RequestContextUtils.getBankParameterValue((String)"payUri"), ((PaymentInfo)paymentInfos.get(0)).getAccNo(), requestStr);
            return this.parse(request, response);
        }
        catch (EBServiceException e) {
            EBContext.getContext().setThrowableAfterSend((Throwable)e);
            return new EBBankPayResponse(paymentInfos);
        }
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        JSONObject total = new JSONObject();
        JSONObject header = DBS_DC_Packer.createHeader(info.getAccNo(), info.getAccCountry());
        header.put("noOfTxs", (Object)"1");
        header.put("totalTxnAmount", (Object)BigDecimalHelper.plain2((BigDecimal)info.getAmount()));
        JSONObject txnInfoDetails = new JSONObject();
        JSONArray list = new JSONArray();
        JSONObject txnInfo = new JSONObject();
        txnInfo.put("customerReference", (Object)info.getBankDetailSeqId());
        txnInfo.put("txnType", (Object)"ACT");
        txnInfo.put("txnDate", (Object)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        txnInfo.put("txnCcy", (Object)info.getCurrency());
        txnInfo.put("txnAmount", (Object)BigDecimalHelper.plain2((BigDecimal)info.getAmount()));
        txnInfo.put("debitAccountCcy", (Object)info.getCurrency());
        txnInfo.put("debitAccountAmount", (Object)BigDecimalHelper.plain2((BigDecimal)info.getAmount()));
        JSONObject senderParty = new JSONObject();
        senderParty.put("name", (Object)info.getAccName());
        senderParty.put("accountNo", (Object)info.getAccNo());
        String accCtry = DBS_DC_Packer.getPayerCountry(info.getAccNo(), info.getAccCountry());
        senderParty.put("bankCtryCode", (Object)accCtry);
        txnInfo.put("senderParty", (Object)senderParty);
        JSONObject receivingParty = new JSONObject();
        String incomeAccName = info.getIncomeAccName();
        if (StringUtils.isNotEmpty((String)incomeAccName) && incomeAccName.length() > 35) {
            incomeAccName = incomeAccName.substring(0, 35);
        }
        receivingParty.put("name", (Object)incomeAccName);
        receivingParty.put("accountNo", (Object)info.getIncomeAccNo());
        txnInfo.put("receivingParty", (Object)receivingParty);
        JSONObject rmtInf = new JSONObject();
        JSONArray paymentDetails = new JSONArray();
        String exp = info.getExplanation();
        if (!StringUtils.isEmpty((String)exp)) {
            JSONObject paymentDetail = new JSONObject();
            if (exp.length() > 35) {
                paymentDetail.put("paymentDetail", (Object)exp.substring(0, 35));
                exp = exp.substring(35, Math.min(exp.length(), 70));
                JSONObject paymentDetail2 = new JSONObject();
                paymentDetail2.put("paymentDetail", (Object)exp);
                paymentDetails.add((Object)paymentDetail2);
            } else {
                paymentDetail.put("paymentDetail", (Object)exp);
            }
            paymentDetails.add((Object)paymentDetail);
        }
        rmtInf.put("paymentDetails", (Object)paymentDetails);
        txnInfo.put("rmtInf", (Object)rmtInf);
        list.add((Object)txnInfo);
        txnInfoDetails.put("txnInfo", (Object)list);
        total.put("txnInfoDetails", (Object)txnInfoDetails);
        total.put("header", (Object)header);
        try {
            return PgpHelper.encry(total.toJSONString());
        }
        catch (Throwable e) {
            this.logger.error("\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38", (String)"ACTPayImpl_0", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        DBS_DC_Parser.parsePay(paymentInfos, s);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u661f\u5c55\u94f6\u884c\u540c\u884c\u4ed8\u6b3e\u63a5\u53e3", (String)"ACTPayImpl_1", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ("ACT".equalsIgnoreCase(paymentInfo.getUseCN())) {
            return true;
        }
        CountryISOCode incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getIncomeCountry());
        if (incomeIsoCode == null) {
            incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
        }
        return paymentInfo.is2SameBank() && incomeIsoCode != null && incomeIsoCode.geteChart2().equalsIgnoreCase("HK");
    }
}

