/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdcs.dc.services;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.banks.sdcs.dc.services.ConnectionUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;

public class SignHelper {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SignHelper.class);

    public static String sign(String data) {
        EBContext context = EBContext.getContext();
        return SignHelper.getSignData(SignHelper.doSign(data, context.getCharsetName()));
    }

    private static String doSign(String data, String charsetName) {
        int length;
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        try {
            length = data.getBytes(charsetName).length;
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7b7e\u540d\u62a5\u6587\u5b57\u8282\u957f\u5ea6\u5f02\u5e38\u3002", (String)"SignHelper_0", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), (Throwable)e);
        }
        factory.setHttpHeader("Content-Length", Integer.toString(length));
        factory.setHttpHeader("Content-Type", "INFOSEC_SIGN/1.0");
        IConnection conn = factory.createSignConnection();
        try {
            String res = ConnectionUtil.sendAndGetReceive(conn, data);
            return res;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ece\u524d\u7f6e\u673a\u83b7\u53d6\u7b7e\u540d\u5931\u8d25\u3002", (String)"SignHelper_1", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static String getSignData(String signData) {
        try {
            Preconditions.checkArgument((!StringUtils.isBlank((String)signData) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"SignHelper_2", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]));
            int start = signData.indexOf("<signed_data>");
            int end = signData.indexOf("</signed_data>");
            Preconditions.checkArgument((start >= 0 && end >= 0 ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u8fd4\u56de\u62a5\u6587<signed_data>\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u4e0d\u5b8c\u6574\u3002", (String)"SignHelper_3", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]));
            String data = signData.substring(start + "<signed_data>".length(), end);
            Preconditions.checkArgument((!StringUtils.isBlank((String)data) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c<signed_data>\u8282\u70b9\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"SignHelper_4", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]));
            return data;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
    }
}

