/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdcs.dc.services.payment.samebank;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdcs.dc.services.PackerHelper;
import kd.ebg.aqap.banks.sdcs.dc.services.ParserHelper;
import kd.ebg.aqap.banks.sdcs.dc.services.payment.PaymentQuery;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class SameBankPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return PaymentQuery.class;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "enterpriseAccPay";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u884c\u8f6c\u8d26", (String)"SameBankPayImpl_0", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        String serial = PackerHelper.getSeq();
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"pay_serial", (String)serial);
        return PackerHelper.packXML(PackerHelper.packParam(paymentInfo), this.getBizCode(), serial);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        ParserHelper.parserPayResult(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(PackerHelper.addUrl());
    }
}

