/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.detail;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.detail.DetailParser;
import kd.ebg.aqap.banks.bocom.dc.service.detail.OsaDetailHelper;
import kd.ebg.aqap.banks.bocom.dc.service.hk.Utils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    public String pack(BankDetailRequest request) {
        Element body;
        Element root;
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        String startDate = request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String endDate = request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        if (BankBusinessConfig.isSecondaryAccount(accNo)) {
            root = BOCOM_DC_Packer.packRoot("585047");
            body = JDomUtils.addChild((Element)root, (String)"body");
            JDomUtils.addChild((Element)body, (String)"man-acno", (String)BankBusinessConfig.getUpAccount(accNo));
            JDomUtils.addChild((Element)body, (String)"mbr-acno", (String)accNo);
        } else {
            if (BankBusinessConfig.isOsaAcnt(accNo)) {
                return OsaDetailHelper.packHisDetail(request);
            }
            root = BOCOM_DC_Packer.packRoot("310301");
            body = JDomUtils.addChild((Element)root, (String)"body");
            JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
            RequestContextUtils.setRunningParam((String)"interface_name", (String)"310301");
        }
        JDomUtils.addChild((Element)body, (String)"start_date", (String)startDate);
        JDomUtils.addChild((Element)body, (String)"end_date", (String)endDate);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        List<DetailInfo> detailInfos = BankBusinessConfig.isOsaAcnt(request.getAcnt().getAccNo()) ? OsaDetailHelper.parseDetail(request, responseStr) : DetailParser.parseHisDetail(request, responseStr);
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "310301";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\u67e5\u8be2", (String)"HisDetailImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(BankDetailRequest request) {
        if (Utils.isHKBiz(request.getAcnt().getAccNo())) {
            return false;
        }
        return "normalDetail".equals(BankBusinessConfig.getDetailInterfaceChoose());
    }
}

