/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.hk.balance;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.hk.Utils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class I430101
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = BOCOM_DC_Packer.packRoot(this.getBizCode());
        Element body = Utils.createBody(root);
        String accNo = ((BankAcnt)bankBalanceRequest.getBankAcntList().get(0)).getAccNo();
        JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"area", (String)BankBusinessConfig.getCountryAreaAccount(accNo));
        String lastAcno = "";
        String lastArea = "";
        String lastCur = "";
        String lastInfo = RequestContextUtils.getRunningParam((String)"lastInfo");
        if (StringUtils.isNotEmpty((String)lastInfo)) {
            JSONObject li = JSONObject.parseObject((String)lastInfo);
            lastAcno = li.getString("lastAcno");
            lastArea = li.getString("lastArea");
            lastCur = li.getString("lastCur");
        }
        JDomUtils.addChild((Element)body, (String)"lastAcno", (String)lastAcno);
        JDomUtils.addChild((Element)body, (String)"lastArea", (String)lastArea);
        JDomUtils.addChild((Element)body, (String)"lastCur", (String)lastCur);
        return Utils.intoString(root);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        this.setLastPage(true);
        Element body = Utils.getBody(s);
        String serialRecord = body.getChildTextTrim("serial_record");
        String field_num = body.getChildTextTrim("field_num");
        String record_num = body.getChildTextTrim("record_num");
        if (StringUtils.isEmpty((String)field_num)) {
            field_num = "0";
        }
        if (StringUtils.isEmpty((String)record_num)) {
            record_num = "0";
        }
        int fieldNum = Integer.parseInt(field_num);
        int recordNum = Integer.parseInt(record_num);
        String[] splits = StringUtils.split((String)serialRecord, (String)"|");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(10);
        for (int i = 1; i <= recordNum; ++i) {
            BalanceInfo balanceInfo = new BalanceInfo();
            String acNo = splits[i * fieldNum];
            String currency = splits[i * fieldNum + 6];
            String bal = splits[i * fieldNum + 7];
            String availBal = splits[i * fieldNum + 8];
            this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), acNo);
            this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency(), currency);
            this.setCurrentBalance(balanceInfo, bal);
            this.setAvailableBalance(balanceInfo, availBal);
            balances.add(balanceInfo);
        }
        String endFlag = body.getChildTextTrim("endflag");
        if ("N".equals(endFlag)) {
            this.setLastPage(false);
            JSONObject pageInfo = new JSONObject();
            pageInfo.put("lastAcno", (Object)body.getChildTextTrim("lastAcno"));
            pageInfo.put("lastArea", (Object)body.getChildTextTrim("lastArea"));
            pageInfo.put("lastCur", (Object)body.getChildTextTrim("lastCur"));
            RequestContextUtils.setRunningParam((String)"lastInfo", (String)pageInfo.toJSONString());
        }
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "430101";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean isSupportPage(BankBalanceRequest request) {
        return true;
    }

    public boolean match(BankBalanceRequest request) {
        return Utils.isHKBiz(((BankAcnt)request.getBankAcntList().get(0)).getAccNo());
    }
}

