/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.hk.pay;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.hk.Utils;
import kd.ebg.aqap.banks.bocom.dc.service.hk.pay.I440103;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class I440101
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return I440103.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = BOCOM_DC_Packer.packRoot(this.getBizCode());
        Element body = Utils.createBody(root);
        JDomUtils.addChild((Element)body, (String)"pyrAccount", (String)paymentInfo.getAccNo());
        String pyrBank = Utils.getPyrBank(paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pyrBank", (String)pyrBank);
        JDomUtils.addChild((Element)body, (String)"pyrCcy", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pyrAmount", (String)"");
        JDomUtils.addChild((Element)body, (String)"pyeAccount", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"pyeName", (String)("3".equalsIgnoreCase(pyrBank) ? "" : paymentInfo.getIncomeAccName()));
        JDomUtils.addChild((Element)body, (String)"benBankName", (String)paymentInfo.getIncomeBankName());
        if ("2".equalsIgnoreCase(pyrBank)) {
            JDomUtils.addChild((Element)body, (String)"pyeCcy", (String)"");
        } else {
            JDomUtils.addChild((Element)body, (String)"pyeCcy", (String)paymentInfo.getPayCurrency());
        }
        JDomUtils.addChild((Element)body, (String)"pyeAmount", (String)paymentInfo.getAmount().toPlainString());
        LocalDateTime bookingTime = paymentInfo.getBookingTime();
        String bespokenFlag = "";
        String bespokenDate = "";
        if (bookingTime != null && bookingTime.toLocalDate().isAfter(LocalDate.now())) {
            bespokenFlag = "Y";
            bespokenDate = bookingTime.format(DateTimeFormatter.BASIC_ISO_DATE);
        }
        JDomUtils.addChild((Element)body, (String)"bespokenFlag", (String)bespokenFlag);
        JDomUtils.addChild((Element)body, (String)"bespokenDate", (String)bespokenDate);
        String bankFlag = paymentInfo.is2SameBank() || "2".equalsIgnoreCase(pyrBank) || "3".equalsIgnoreCase(pyrBank) ? "0" : "1";
        JDomUtils.addChild((Element)body, (String)"bankFlag", (String)bankFlag);
        JDomUtils.addChild((Element)body, (String)"coverBank", (String)paymentInfo.getIncomeBankLocalClearingCode());
        JDomUtils.addChild((Element)body, (String)"dealRef", (String)"");
        JDomUtils.addChild((Element)body, (String)"bvCode", (String)paymentInfo.getBankDetailSeqId());
        String remitPurpose = "4";
        if ("2".equalsIgnoreCase(pyrBank) || "3".equalsIgnoreCase(pyrBank)) {
            remitPurpose = "";
        }
        JDomUtils.addChild((Element)body, (String)"remitPurpose", (String)remitPurpose);
        String remark = "";
        if (StringUtils.isEmpty((String)pyrBank) || "3".equalsIgnoreCase(pyrBank)) {
            remark = paymentInfo.getExplanation();
        }
        JDomUtils.addChild((Element)body, (String)"remark", (String)remark);
        String chrgType = "";
        String chrgAccount = "";
        String chrgCcy = "";
        if ("1".equalsIgnoreCase(bankFlag) && !"2".equalsIgnoreCase(pyrBank) && !"3".equalsIgnoreCase(pyrBank)) {
            if ("01".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                chrgType = "3";
            } else if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                chrgAccount = paymentInfo.getPayerFeeAccNo();
                chrgType = "1";
                chrgCcy = paymentInfo.getPayerFeeCurrency();
            } else {
                chrgAccount = paymentInfo.getPayerFeeAccNo();
                chrgType = "2";
                chrgCcy = paymentInfo.getPayerFeeCurrency();
            }
        }
        JDomUtils.addChild((Element)body, (String)"chrgType", (String)chrgType);
        JDomUtils.addChild((Element)body, (String)"chrgAccount", (String)chrgAccount);
        JDomUtils.addChild((Element)body, (String)"chrgCcy", (String)chrgCcy);
        JDomUtils.addChild((Element)body, (String)"payPurpose", (String)"");
        JDomUtils.addChild((Element)body, (String)"remitPurposeDesc", (String)paymentInfo.getPayeeUse());
        JDomUtils.addChild((Element)body, (String)"payPurposeDesc", (String)"");
        JDomUtils.addChild((Element)body, (String)"creditorName", (String)("3".equalsIgnoreCase(pyrBank) ? "" : paymentInfo.getIncomeAccName()));
        if (("1".equalsIgnoreCase(pyrBank) || "4".equalsIgnoreCase(pyrBank)) && "1".equalsIgnoreCase(bankFlag)) {
            JDomUtils.addChild((Element)body, (String)"cdtrDepartment", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrSubdepartment", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrStreetName", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrBuildingNumber", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrBuildingName", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrFloor", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrPostBox", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrRoom", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrPostCode", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrTownName", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrTownLocationName", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrDistrictName", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrCountrySubDivision", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrCountry", (String)Utils.getCountry(paymentInfo.getIncomeCountry()));
        } else {
            JDomUtils.addChild((Element)body, (String)"cdtrDepartment", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrSubdepartment", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrStreetName", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrBuildingNumber", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrBuildingName", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrFloor", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrPostBox", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrRoom", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrPostCode", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrTownName", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrTownLocationName", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrDistrictName", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrCountrySubDivision", (String)"");
            JDomUtils.addChild((Element)body, (String)"cdtrCountry", (String)"");
        }
        JDomUtils.addChild((Element)body, (String)"creditorAddr1", (String)"");
        JDomUtils.addChild((Element)body, (String)"creditorAddr2", (String)"");
        JDomUtils.addChild((Element)body, (String)"creditorAddr3", (String)"");
        return Utils.intoString(root);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(root);
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "440101";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

