/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.hk.pay;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.hk.Utils;
import kd.ebg.aqap.banks.bocom.dc.service.hk.pay.I440103;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class I440102
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return I440103.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        boolean hk_macao;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = BOCOM_DC_Packer.packRoot(this.getBizCode());
        Element body = Utils.createBody(root);
        JDomUtils.addChild((Element)body, (String)"remitAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"remiterName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"msgType", (String)"");
        JDomUtils.addChild((Element)body, (String)"remiterAcctBkBic", (String)paymentInfo.getIncomeSwiftCode());
        String remitBank = Utils.getRemitBank(paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"remiterAcctBk", (String)remitBank);
        JDomUtils.addChild((Element)body, (String)"bvCode", (String)paymentInfo.getBankDetailSeqId());
        String remitCur = paymentInfo.getCurrency();
        if (paymentInfo.isDiffCurrency()) {
            remitCur = bankPayRequest.getAcnt().getCurrency();
        }
        JDomUtils.addChild((Element)body, (String)"remitCur", (String)remitCur);
        if ("100".equalsIgnoreCase(remitBank)) {
            JDomUtils.addChild((Element)body, (String)"remitAmt", (String)paymentInfo.getAmount().toPlainString());
        } else {
            JDomUtils.addChild((Element)body, (String)"remitAmt", (String)"");
        }
        JDomUtils.addChild((Element)body, (String)"payCur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"payAmt", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)body, (String)"dealRef", (String)"");
        JDomUtils.addChild((Element)body, (String)"pyeAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"pyeName", (String)paymentInfo.getIncomeAccName());
        int AddrLen = 140 - paymentInfo.getIncomeAccName().length();
        if (AddrLen < 0) {
            AddrLen = 0;
        }
        JDomUtils.addChild((Element)body, (String)"pyeAddr", (String)paymentInfo.getIncomeAddress().substring(0, Math.min(paymentInfo.getIncomeAddress().length(), AddrLen)));
        boolean bl = hk_macao = "1".equalsIgnoreCase(remitBank) || "3".equalsIgnoreCase(remitBank) || "4".equalsIgnoreCase(remitBank);
        if (hk_macao) {
            String pyeBankType = paymentInfo.is2SameBank() ? "0" : "1";
            JDomUtils.addChild((Element)body, (String)"pyeBankType", (String)pyeBankType);
        } else {
            JDomUtils.addChild((Element)body, (String)"pyeBankType", (String)"");
        }
        JDomUtils.addChild((Element)body, (String)"benBank", (String)paymentInfo.getIncomeSwiftCode());
        if ("100".equalsIgnoreCase(remitBank)) {
            JDomUtils.addChild((Element)body, (String)"benBankNameAddr", (String)"");
        } else {
            JDomUtils.addChild((Element)body, (String)"benBankNameAddr", (String)paymentInfo.getIncomeBankAddress());
        }
        JDomUtils.addChild((Element)body, (String)"benTelNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"benFaxNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"benEmailAddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"country", (String)Utils.getCountry(paymentInfo.getIncomeCountry()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)"4");
        JDomUtils.addChild((Element)body, (String)"remitAccountDesc", (String)paymentInfo.getPayeeUse());
        JDomUtils.addChild((Element)body, (String)"remitterTel", (String)paymentInfo.getApplyPhone());
        JDomUtils.addChild((Element)body, (String)"commodityCode", (String)"");
        LocalDateTime bookingTime = paymentInfo.getBookingTime();
        String bespokenFlag = "";
        String bespokenDate = "";
        if (bookingTime != null && bookingTime.toLocalDate().isAfter(LocalDate.now())) {
            bespokenFlag = "Y";
            bespokenDate = bookingTime.format(DateTimeFormatter.BASIC_ISO_DATE);
        }
        JDomUtils.addChild((Element)body, (String)"bespokenFlag", (String)bespokenFlag);
        JDomUtils.addChild((Element)body, (String)"bespokenDate", (String)bespokenDate);
        String chrgType = "";
        String chrgAccount = "";
        String chrgCcy = "";
        if (hk_macao) {
            if ("01".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                chrgType = "3";
            } else if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                chrgAccount = paymentInfo.getPayerFeeAccNo();
                chrgType = "1";
                chrgCcy = paymentInfo.getPayerFeeCurrency();
            } else {
                chrgAccount = paymentInfo.getPayerFeeAccNo();
                chrgType = "2";
                chrgCcy = paymentInfo.getPayerFeeCurrency();
            }
        }
        JDomUtils.addChild((Element)body, (String)"chrAcctNo", (String)chrgAccount);
        JDomUtils.addChild((Element)body, (String)"chrPayType", (String)chrgType);
        JDomUtils.addChild((Element)body, (String)"chrgCcy", (String)chrgCcy);
        JDomUtils.addChild((Element)body, (String)"remitRemark", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"benCorrBank", (String)paymentInfo.getProxyBankSwiftCode());
        JDomUtils.addChild((Element)body, (String)"benCorrBankNameAddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"benCorrAc", (String)paymentInfo.getProxyAccNo());
        JDomUtils.addChild((Element)body, (String)"creditorName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"creditorAddr1", (String)paymentInfo.getIncomeAddress());
        JDomUtils.addChild((Element)body, (String)"creditorAddr2", (String)paymentInfo.getIncomeCity());
        JDomUtils.addChild((Element)body, (String)"creditorAddr3", (String)Utils.getCountry(paymentInfo.getIncomeCountry()));
        return Utils.intoString(root);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(root);
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "440102";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

