/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.salary;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.payment.salary.QueryAuthoritySalaryPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AuthoritySalaryPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 3000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryAuthoritySalaryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = BOCOM_DC_Packer.packRoot(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        if (UseConvertor.isReim((PaymentInfo)((PaymentInfo)paymentInfos.get(0)))) {
            JDomUtils.addChild((Element)body, (String)"type", (String)"1");
        } else {
            JDomUtils.addChild((Element)body, (String)"type", (String)"0");
        }
        JDomUtils.addChild((Element)body, (String)"selsec_flg", (String)BankBusinessConfig.getSelectFlag());
        JDomUtils.addChild((Element)body, (String)"pay_month", (String)new SimpleDateFormat("yyyyMM").format(new Date()));
        JDomUtils.addChild((Element)body, (String)"summary", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        String busiNo = BankBusinessConfig.getPayrollNo(((PaymentInfo)paymentInfos.get(0)).getAccNo(), "");
        if (StringUtils.isEmpty((String)busiNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u534f\u8bae\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u7ef4\u62a4\u3002", (String)"AuthoritySalaryPaymentImpl_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"busi_no", (String)busiNo);
        if (((PaymentInfo)paymentInfos.get(0)).is2Merge()) {
            JDomUtils.addChild((Element)body, (String)"mailflg", (String)"Y");
        } else {
            JDomUtils.addChild((Element)body, (String)"mailflg", (String)"N");
        }
        JDomUtils.addChild((Element)body, (String)"is_cert_no", (String)"");
        JDomUtils.addChild((Element)body, (String)"see_flg", (String)"0");
        Element tran = JDomUtils.addChild((Element)body, (String)"tran");
        for (PaymentInfo paymentInfo : paymentInfos) {
            Element rcd = JDomUtils.addChild((Element)tran, (String)"rcd");
            JDomUtils.addChild((Element)rcd, (String)"card_no", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)rcd, (String)"acname", (String)paymentInfo.getIncomeAccName());
            if (paymentInfo.is2SameBank()) {
                JDomUtils.addChild((Element)rcd, (String)"card_flag", (String)"A");
            } else {
                JDomUtils.addChild((Element)rcd, (String)"card_flag", (String)"B");
            }
            JDomUtils.addChild((Element)rcd, (String)"rcv_bank_no", (String)paymentInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)rcd, (String)"amt", (String)paymentInfo.getAmount().toPlainString());
            JDomUtils.addChild((Element)rcd, (String)"busino", (String)paymentInfo.getBankDetailSeqId());
        }
        JDomUtils.addChild((Element)body, (String)"sum", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"sum_amt", (String)((PaymentInfo)paymentInfos.get(0)).getTotalAmount().toPlainString());
        String encoding = RequestContextUtils.getCharset();
        String message = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "330018";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7f51\u94f6\u6388\u6743\u8de8\u884c\u4ee3\u53d1\u63a5\u53e3", (String)"AuthoritySalaryPaymentImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

