/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.constants.CMBRequestState;
import kd.ebg.aqap.banks.cmb.dc.constants.CMBReturnFlgState;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CMB_DC_PayParser {
    private static void parsePayRd(List<PaymentInfo> paymentInfos, List<Element> ntqpayrqzs) {
        for (int i = 0; i < ntqpayrqzs.size(); ++i) {
            Element ntqpayrqz = ntqpayrqzs.get(i);
            String reqnbr = ntqpayrqz.getChildTextTrim("REQNBR");
            String yurref = ntqpayrqz.getChildTextTrim("YURREF");
            String reqsts = ntqpayrqz.getChildTextTrim("REQSTS");
            String rtnflg = ntqpayrqz.getChildTextTrim("RTNFLG");
            String errcod = ntqpayrqz.getChildTextTrim("ERRCOD");
            String errtxt = ntqpayrqz.getChildTextTrim("ERRTXT");
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)PaymentUtil.getSeqIdFromYurref(yurref));
            if (null == paymentInfo) continue;
            PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"REQNUBR", (String)reqnbr);
            if ("FIN".equalsIgnoreCase(reqsts)) {
                if ("F".equalsIgnoreCase(rtnflg) || "R".equals(rtnflg)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CMB_DC_PayParser_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)errcod, (String)errtxt);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rtnflg, (String)CMBReturnFlgState.flagMaps.get(rtnflg));
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)reqsts, (String)CMBRequestState.reqstsMap.get(reqsts));
        }
    }

    public static void parsePay(List<PaymentInfo> paymentInfos, String retMessage) {
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)retMessage, (String)encoding);
        BankResponse headRsp = CMB_DC_Parser.parseINFO(root);
        List ntqpayrqzs = root.getChildren("NTQPAYRQZ");
        if ("0".equalsIgnoreCase(headRsp.getResponseCode())) {
            if (paymentInfos.size() <= 30) {
                CMB_DC_PayParser.parsePayRd(paymentInfos, ntqpayrqzs);
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
        }
    }

    public static void parseAgentPay(List<PaymentInfo> paymentInfos, String retMessage) {
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)retMessage, (String)encoding);
        BankResponse headRsp = CMB_DC_Parser.parseINFO(root);
        List ntagprtnz = root.getChildren("NTAGPRTNZ");
        if ("0".equalsIgnoreCase(headRsp.getResponseCode())) {
            if (paymentInfos.size() <= 30) {
                CMB_DC_PayParser.parsePayRd(paymentInfos, ntagprtnz);
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
        }
    }

    public static void parseIndividualPay(List<PaymentInfo> paymentInfos, String rspStr) {
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse headRsp = CMB_DC_Parser.parseINFO(root);
        if ("0".equalsIgnoreCase(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
        }
    }
}

