/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.area.CMBStore;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = (BankAcnt)request.getBankAcntList().get(0);
        String accNo = acnt.getAccNo();
        String branchNo = CMBStore.getInstance().getAreaCode(acnt);
        Element root = CMB_DC_Packer.packRoot("SDKNTQABINF");
        Element ntqabinfy = JDomUtils.addChild((Element)root, (String)"NTQABINFY");
        JDomUtils.addChild((Element)ntqabinfy, (String)"BBKNBR", (String)branchNo);
        JDomUtils.addChild((Element)ntqabinfy, (String)"ACCNBR", (String)accNo);
        JDomUtils.addChild((Element)ntqabinfy, (String)"BGNDAT", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)ntqabinfy, (String)"ENDDAT", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String encoding = EBContext.getContext().getCharsetName();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse headRsp = CMB_DC_Parser.parseINFO(root);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = ShowTipUtil.getResponseErrorTips((String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        List balanceList = root.getChildren("NTQABINFZ");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(16);
        if (balanceList != null) {
            for (Element node : balanceList) {
                BalanceInfo info = new BalanceInfo();
                balances.add(info);
                String accNo = node.getChildTextTrim("ACCNBR");
                String balance = node.getChildTextTrim("BALAMT");
                String blanceDateStr = node.getChildTextTrim("TRSDAT");
                this.setCurrentBalance(info, balance);
                BankAcnt bankAcnt = new BankAcnt();
                info.setBankAcnt(bankAcnt);
                this.setBankAcnt(info, request.getBankAcntList(), accNo);
                this.setBankCurrency(info, request.getHeader().getBankCurrency());
                try {
                    LocalDate balanceDate = LocalDate.parse(blanceDateStr, DateTimeFormatter.ofPattern("yyyyMMdd"));
                    info.setBalanceDateTime(LocalDateTime.of(balanceDate, LocalTime.now()));
                }
                catch (Exception e) {
                    info.setError(BalanceUtils.wrongDateFormatter());
                }
            }
        }
        return new EBBankBalanceResponse(balances);
    }

    public LocalDate limitDate() {
        return LocalDate.of(1970, 1, 1);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "SDKNTQABINF";
    }

    public int queryDays() {
        return 31;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_5", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

