/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.authorized;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_PayParser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.authorized.AuthorizedQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AuthorizedPayImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AuthorizedQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "Payment";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u7801\u662fPayment,N02030:\u6388\u6743\u652f\u4ed8", (String)"AuthorizedPayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return BankBusinessConfig.isPaymetByAuthorized();
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String dbtbbk = paymentInfo.getAreaCode();
        Element root = CMB_DC_Packer.packRoot("Payment");
        Element sdkpayrqx = JDomUtils.addChild((Element)root, (String)"SDKPAYRQX");
        JDomUtils.addChild((Element)sdkpayrqx, (String)"BUSCOD", (String)"N02030");
        String accNo = paymentInfo.getAccNo();
        String busmod = BankBusinessConfig.getN02030Busmod(accNo);
        String modals = BankBusinessConfig.getN02030Modals(accNo);
        if (StringUtils.isEmpty((String)busmod) && StringUtils.isEmpty((String)modals)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62db\u884c\u7684\u7f51\u94f6\u6388\u6743\u4ed8\u6b3e\u4e1a\u52a1[\u4ea4\u6613\u7801:N02030],\u2018\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\u2019\u548c\u2018\u4e1a\u52a1\u6a21\u5f0f\u540d\u79f0\u2019\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a.\u8bf7\u5230\u94f6\u4f01\u4e91WEB\u754c\u9762\u7684[\u8d26\u53f7\u7ba1\u7406]\u4e2d\u914d\u7f6e\u8d26\u53f7\u7684'\u9644\u52a0\u5c5e\u6027'\uff01", (String)"AuthorizedPayImpl_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)sdkpayrqx, (String)"BUSMOD", (String)busmod);
        JDomUtils.addChild((Element)sdkpayrqx, (String)"MODALS", (String)modals);
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            kd.ebg.aqap.business.payment.utils.PaymentUtil.setKdFlagIDByBankDetailSeqID((List)paymentInfos);
        }
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element sdkpaydtx = JDomUtils.addChild((Element)root, (String)"SDKPAYDTX");
            JDomUtils.addChild((Element)sdkpaydtx, (String)"YURREF", (String)PaymentUtil.setBankDetailRefID((PaymentInfo)paymentInfos.get(i)));
            if (((PaymentInfo)paymentInfos.get(i)).getBookingTime() != null && ((PaymentInfo)paymentInfos.get(i)).getBookingTime().isAfter(LocalDateTime.now())) {
                JDomUtils.addChild((Element)sdkpaydtx, (String)"EPTDAT", (String)((PaymentInfo)paymentInfos.get(i)).getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                kd.ebg.aqap.business.payment.utils.PaymentUtil.setBookPayFlag((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            }
            JDomUtils.addChild((Element)sdkpaydtx, (String)"DBTACC", (String)((PaymentInfo)paymentInfos.get(i)).getAccNo());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"DBTBBK", (String)dbtbbk);
            JDomUtils.addChild((Element)sdkpaydtx, (String)"TRSAMT", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CCYNBR", (String)((PaymentInfo)paymentInfos.get(i)).getCurrency());
            String stlchn = ((PaymentInfo)paymentInfos.get(i)).getUrgent() != false ? "F" : "N";
            JDomUtils.addChild((Element)sdkpaydtx, (String)"STLCHN", (String)stlchn);
            JDomUtils.addChild((Element)sdkpaydtx, (String)"NUSAGE", (String)StringUtils.substringChinese((String)((PaymentInfo)paymentInfos.get(i)).getExplanation(), (String)EBContext.getContext().getCharsetName(), (int)62));
            JDomUtils.addChild((Element)sdkpaydtx, (String)"BUSNAR", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTACC", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTNAM", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            if (!StringUtils.isEmpty((String)((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps())) {
                JDomUtils.addChild((Element)sdkpaydtx, (String)"BRDNBR", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps());
            }
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTBNK", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeBankName());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTPVC", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeProvince());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTCTY", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCity());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"NTFCH1", (String)((PaymentInfo)paymentInfos.get(i)).getEmails());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"NTFCH2", (String)((PaymentInfo)paymentInfos.get(i)).getMobiles());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTSQN", (String)"");
        }
        return JDomUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        CMB_DC_PayParser.parsePay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

