/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.linkpay;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_PayParser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.linkpay.LinkQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.INativeLinkPayable;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class LinkPayImpl
extends AbstractPayImpl
implements IPay,
INativeLinkPayable {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return LinkQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "qiang";
    }

    public String getBizCode() {
        return "DCPAYMNT";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8", (String)"LinkPayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_linkpay".equalsIgnoreCase(paymentInfo.getSubBizType()) || "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.is2Individual() && BankBusinessConfig.individualToDirectPay();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        String dbtbbk = paymentInfos[0].getAreaCode();
        String encoding = RequestContextUtils.getCharset();
        Element root = CMB_DC_Packer.packRoot("DCPAYMNT");
        Element sdkpayrqx = JDomUtils.addChild((Element)root, (String)"SDKPAYRQX");
        String buscod = paymentInfos[0].getSubBizType().equalsIgnoreCase("pay") ? "N02031" : "N02041";
        JDomUtils.addChild((Element)sdkpayrqx, (String)"BUSCOD", (String)buscod);
        JDomUtils.addChild((Element)sdkpayrqx, (String)"BUSMOD", (String)RequestContextUtils.getBankParameterValue((String)"BUSMOD4DirectPay"));
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            kd.ebg.aqap.business.payment.utils.PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo[])paymentInfos);
        }
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element dcopdpayx = JDomUtils.addChild((Element)root, (String)"DCOPDPAYX");
            JDomUtils.addChild((Element)dcopdpayx, (String)"YURREF", (String)PaymentUtil.setBankDetailRefID(paymentInfos[i]));
            JDomUtils.addChild((Element)dcopdpayx, (String)"DBTACC", (String)paymentInfos[i].getAccNo());
            JDomUtils.addChild((Element)dcopdpayx, (String)"DBTBBK", (String)dbtbbk);
            JDomUtils.addChild((Element)dcopdpayx, (String)"TRSAMT", (String)paymentInfos[i].getAmount().toString());
            JDomUtils.addChild((Element)dcopdpayx, (String)"CCYNBR", (String)paymentInfos[i].getCurrency());
            String stlchn = paymentInfos[i].is2Urgent() ? "F" : "N";
            JDomUtils.addChild((Element)dcopdpayx, (String)"STLCHN", (String)stlchn);
            JDomUtils.addChild((Element)dcopdpayx, (String)"NUSAGE", (String)StringUtils.substringChinese((String)paymentInfos[i].getExplanation(), (String)encoding, (int)62));
            JDomUtils.addChild((Element)dcopdpayx, (String)"BUSNAR", (String)paymentInfos[i].getExplanation());
            JDomUtils.addChild((Element)dcopdpayx, (String)"CRTACC", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)dcopdpayx, (String)"CRTNAM", (String)paymentInfos[i].getIncomeAccName());
            if (!StringUtils.isEmpty((String)paymentInfos[i].getIncomeCnaps())) {
                JDomUtils.addChild((Element)dcopdpayx, (String)"BRDNBR", (String)paymentInfos[i].getIncomeCnaps());
            }
            JDomUtils.addChild((Element)dcopdpayx, (String)"BNKFLG", (String)(paymentInfos[i].is2SameBank() ? "Y" : "N"));
            JDomUtils.addChild((Element)dcopdpayx, (String)"CRTBNK", (String)paymentInfos[i].getIncomeBankName());
            JDomUtils.addChild((Element)dcopdpayx, (String)"CTYCOD", (String)paymentInfos[i].getIncomeAreaCode());
            JDomUtils.addChild((Element)dcopdpayx, (String)"CRTADR", (String)paymentInfos[i].getIncomeBankAddress());
            JDomUtils.addChild((Element)dcopdpayx, (String)"CRTFLG", (String)"Y");
            JDomUtils.addChild((Element)dcopdpayx, (String)"NTFCH1", (String)paymentInfos[i].getEmails());
            JDomUtils.addChild((Element)dcopdpayx, (String)"NTFCH2", (String)paymentInfos[i].getMobiles());
            JDomUtils.addChild((Element)dcopdpayx, (String)"CRTSQN", (String)"");
            PaymentInfoSysFiled.set((PaymentInfo)paymentInfos[i], (String)PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, (String)paymentInfos[i].getBankDetailSeqId());
        }
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        CMB_DC_PayParser.parsePay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

