/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.global.service.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.global.utils.ABC_Global_Packer;
import kd.ebg.aqap.banks.abc.global.utils.ABC_Global_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        Element root = ABC_Global_Packer.createABCRoot4New("GQRA38", Sequence.genSequence());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)bankBalanceRequest.getBankCurrency());
        return ABC_Global_Packer.covert2ABCMessage(root);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Element root = ABC_Global_Parser.parseString2Root(s);
        BankResponse bankResponse = ABC_Global_Parser.parseHeader(root);
        if (!"0000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        Element business = root.getChild("Business");
        String account = JDomUtils.getChildText((Element)business, (String)"account");
        String ledgerBal = JDomUtils.getChildText((Element)business, (String)"ledger_bal");
        String availableBal = JDomUtils.getChildText((Element)business, (String)"available_bal");
        BalanceInfo balance = new BalanceInfo();
        this.setBankAcnt(balance, bankBalanceRequest.getBankAcntList(), account);
        this.setCurrentBalance(balance, ledgerBal);
        this.setAvailableBalance(balance, availableBal);
        balance.setBankCurrency(bankBalanceRequest.getBankCurrency());
        balance.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GQRA38";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u5883\u67e5\u8be2\u5b9e\u65f6\u4f59\u989d", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-abc-global", (Object[])new Object[0]);
    }
}

