/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ksrcb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ksrcb.dc.utils.DownLoadFrontProxy;
import kd.ebg.aqap.banks.ksrcb.dc.utils.TCommon;
import kd.ebg.aqap.banks.ksrcb.dc.utils.TPacker;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        String bankRequestSeq = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "200110";
        Element ap = TPacker.createCommonHead(tr_code, bankRequestSeq);
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(xmlMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse response = new EBBankDetailResponse();
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(1);
        Element ap = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element head = ap.getChild("head");
        Element body = ap.getChild("body");
        BankResponse bankResponse = TCommon.parseBankResponse(head);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6\u5931\u8d25,\u539f\u56e0:%1$s,%2$s", (String)"DetailImpl_3", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
        }
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            log.info("\u672c\u6b21\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            response.setDetails(details);
            return response;
        }
        String file_flag = head.getChildTextTrim("file_flag");
        String content = "";
        if ("1".equals(file_flag)) {
            log.info("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            try {
                content = new DownLoadFrontProxy().doBiz(file_name);
            }
            catch (Exception e) {
                log.error("\u4ece\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"[\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            log.info("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        String[][] rs = this.parseMFS(content, recordNum, fieldNum);
        for (int i = 0; i < rs.length; ++i) {
            String[] r = rs[i];
            DetailInfo detailInfo = this.parseRecord(r);
            details.add(detailInfo);
        }
        log.info("---\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u7ed3\u675f---");
        response.setDetails(details);
        return response;
    }

    private DetailInfo parseRecord(String[] r) {
        String serial_no = r[0];
        String acno = r[1];
        String tr_currency = r[2];
        String tr_acdt = r[3];
        String tr_time = r[4];
        String acname = r[7];
        String opp_acno = r[8];
        String opp_acname = r[10];
        String oppbank = r[11];
        String crdr_flag = r[23];
        String amt = r[24];
        String balance = r[25];
        String cert_batchno = r[29];
        String cert_no = r[30];
        String summary = r[34];
        String postscript = r[35];
        String payamt = r[43];
        String rcvamt = r[44];
        DetailInfo detailInfo = new DetailInfo();
        detailInfo.setAccNo(acno);
        detailInfo.setAccName(acname);
        detailInfo.setOppAccNo(opp_acno);
        detailInfo.setOppAccName(opp_acname);
        detailInfo.setBankName(oppbank);
        detailInfo.setCurrency(tr_currency);
        try {
            if (!StringUtils.isEmpty((String)tr_acdt)) {
                if (!StringUtils.isEmpty((String)tr_time)) {
                    String tran_date = tr_acdt + tr_time;
                    detailInfo.setTransDate(LocalDate.parse(tran_date, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                    detailInfo.setTransTime(LocalDateTime.parse(tran_date, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                } else {
                    String tran_date = tr_acdt + "000000";
                    detailInfo.setTransDate(LocalDate.parse(tran_date, DateTimeFormatter.ofPattern("yyyyMMdd")));
                    detailInfo.setTransTime(LocalDateTime.parse(tran_date, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                }
            }
        }
        catch (Exception e) {
            log.error("\u4ea4\u6613\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        if ("D".equalsIgnoreCase(crdr_flag)) {
            detailInfo.setDebitAmount(new BigDecimal(payamt));
            detailInfo.setCreditAmount(new BigDecimal("0.00"));
        }
        if ("C".equalsIgnoreCase(crdr_flag)) {
            detailInfo.setDebitAmount(new BigDecimal("0.00"));
            detailInfo.setCreditAmount(new BigDecimal(rcvamt));
        }
        if (!StringUtils.isEmpty((String)summary)) {
            String[] strArr;
            if (summary.indexOf("KD@") != -1 && (strArr = StringUtils.split((String)summary, (String)"KD@")).length > 1) {
                summary = strArr[1];
                detailInfo.setPayBankDetailSeqID(strArr[0]);
            }
            detailInfo.setExplanation(summary);
        } else {
            detailInfo.setExplanation(postscript);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("TR_ACDT", (Object)tr_acdt);
        jsonObject.put("SERIAL_NO", (Object)serial_no);
        jsonObject.put("PURPOSE", (Object)summary);
        jsonObject.put("POSTSCRIPT", (Object)postscript);
        detailInfo.setJsonMap(jsonObject.toJSONString());
        detailInfo.setBankDetailNo(serial_no);
        if (StringUtils.isNotEmpty((String)balance)) {
            detailInfo.setBalance(new BigDecimal(balance));
        }
        return detailInfo;
    }

    private String[][] parseMFS(String content, int recordNum, int fieldNum) {
        String[] allRecord = StringUtils.split((String)content, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allRecord[i * fieldNum + j];
            }
        }
        return r2;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u4fe1\u606f", (String)"DetailImpl_2", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return TCommon.parseRecvMsg(super.recv(inputStream));
    }
}

