/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.bank.meta.template;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataInfo;
import kd.ebg.aqap.common.framework.bank.meta.BankVersionMetaInfo;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public abstract class SFTPMetaDataTemplate
extends BankMetaDataInfo
implements BankMetaDataCollector {
    @Override
    public BankVersionMetaInfo getBankVersionMetaInfo() {
        this.metaDataInit();
        String dLockNum = this.bankShortName + "_concurrentCount";
        int concurrentCount = 0;
        try {
            String dLockNumString = ConfigurationUtil.getString((String)dLockNum);
            if (!StringUtils.isEmpty((String)dLockNumString)) {
                concurrentCount = Integer.parseInt(dLockNumString);
            }
        }
        catch (Exception e) {
            concurrentCount = 1;
        }
        return BankVersionMetaInfo.builder().bankShortName(this.bankShortName).bankName(this.bankName).bankVersionID(this.bankVersionID).bankVersionName(this.bankVersionName).description(this.description).keyNames(this.keyNames).concurrentCount(concurrentCount).build();
    }

    @Override
    public List<BankLoginConfig> getBankLoginConfig() {
        this.baseConfigInit();
        ArrayList<BankLoginConfig> bankLoginConfig = new ArrayList<BankLoginConfig>(16);
        List<BankLoginConfig> configs = this.getBankLoginSftpWayConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.SFTP_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginSftpWaySupplement();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.SFTP_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginExtraConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.EXTRA_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getPgpConfigSupplement();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.PGP_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        return bankLoginConfig;
    }

    public List<BankLoginConfig> getBankLoginSftpWaySupplement() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginSftpWayConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"ip", (MultiLangEnumBridge)new MultiLangEnumBridge("SFTP\u670d\u52a1\u5668IP\u5730\u5740", "SFTPMetaDataTemplate_0", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884cSFTP\u670d\u52a1\u5668IP\u5730\u5740\uff0c\u94f6\u884c\u63d0\u4f9b", "SFTPMetaDataTemplate_1", "ebg-aqap-common"), (String)this.host, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangePort", (MultiLangEnumBridge)new MultiLangEnumBridge("SFTP\u7aef\u53e3\u53f7", "SFTPMetaDataTemplate_2", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f00\u653e\u94f6\u4f01\u8bbf\u95ee\u7684SFTP\u7aef\u53e3\u53f7\uff0c\u8bf7\u786e\u4fdd\u94f6\u4f01\u53ef\u8bbf\u95ee", "SFTPMetaDataTemplate_3", "ebg-aqap-common"), (String)this.port, (boolean)false, (boolean)false).set2Integer().set2MaxValueNum(65535), BankLoginConfigUtil.getMlBankLoginConfig((String)"charset", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5b57\u7b26\u96c6", "SFTPMetaDataTemplate_4", "ebg-aqap-common"), (String)this.charset, (boolean)true, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_upload_path", (MultiLangEnumBridge)new MultiLangEnumBridge("SFTP\u6587\u4ef6\u4e0a\u4f20\u8def\u5f84", "SFTPMetaDataTemplate_5", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6587\u4ef6\u4e0a\u4f20\u8def\u5f84", "SFTPMetaDataTemplate_6", "ebg-aqap-common"), (String)"/", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_download_path", (MultiLangEnumBridge)new MultiLangEnumBridge("SFTP\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84", "SFTPMetaDataTemplate_7", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84", "SFTPMetaDataTemplate_8", "ebg-aqap-common"), (String)"/", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_user_name", (MultiLangEnumBridge)new MultiLangEnumBridge("\u767b\u5f55SFTP\u670d\u52a1\u5668\u4f7f\u7528\u7684\u7528\u6237\u540d", "SFTPMetaDataTemplate_9", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_password", (MultiLangEnumBridge)new MultiLangEnumBridge("\u767b\u5f55SFTP\u670d\u52a1\u5668\u4f7f\u7528\u7684\u5bc6\u7801", "SFTPMetaDataTemplate_10", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_cert_path", (MultiLangEnumBridge)new MultiLangEnumBridge("SFTP\u8bc1\u4e66\u6587\u4ef6", "SFTPMetaDataTemplate_11", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true, (String)"upload")});
    }

    @Override
    public List<BankVersionMetaInfo> getBankVersionExtMetaInfos() {
        this.metaDataInit();
        String fileName = this.bankVersionID + "_BankInfoExt.json";
        return this.initBankVersionMetaExtInfo(fileName);
    }

    public List<BankLoginConfig> getPgpConfigSupplement() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginExtraConfig() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankService>> getBizImplClasses() {
        return null;
    }

    @Override
    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public BankPropertyConfig getPropertyConfig() {
        return null;
    }

    @Override
    public boolean showInJdy() {
        return false;
    }
}

