/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.reconciliation.processor;

import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.common.framework.reconciliation.AbstractKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.find.FindNodeInfo;
import kd.ebg.aqap.common.framework.reconciliation.processor.FileKDProcessor;
import kd.ebg.egf.common.utils.string.StringUtils;

public class FileEnhanceKDProcessor
extends AbstractKDProcessor {
    public static String LINE_SEPARATOR = "\r\n";
    private int recordNum;
    private boolean skipFirstLine;
    private char separator;
    private int charOffset;
    private int paymentSize;

    @Override
    public List<FindNodeInfo> handle(String data, String nodePath) {
        ArrayList<FindNodeInfo> nodeInfoList = new ArrayList<FindNodeInfo>(16);
        if (StringUtils.isNotEmpty((String)data) && StringUtils.isNotEmpty((String)nodePath)) {
            this.separator = nodePath.charAt(0);
            String content = this.preTreatContent(data);
            nodeInfoList.addAll(new FileKDProcessor().handle(content, nodePath));
        }
        if (this.getCharOffset() > 0) {
            for (int i = 0; i < nodeInfoList.size(); ++i) {
                FindNodeInfo nodeInfo = (FindNodeInfo)nodeInfoList.get(i);
                int startIndex = nodeInfo.getStartIndex() - i * this.getCharOffset();
                int endIndex = nodeInfo.getEndIndex() - i * this.getCharOffset();
                nodeInfo.setStartIndex(startIndex);
                nodeInfo.setEndIndex(endIndex);
            }
        }
        if (this.isSkipFirstLine() && nodeInfoList.size() > 0) {
            return nodeInfoList.subList(1, nodeInfoList.size());
        }
        return nodeInfoList;
    }

    private String preTreatContent(String content) {
        if (this.recordNum == 0 || StringUtils.isEmpty((String)content)) {
            return content;
        }
        boolean lineSeparator = content.indexOf(10) > -1;
        StringBuilder sb = new StringBuilder();
        if (lineSeparator) {
            String[] data = FileEnhanceKDProcessor.split(content, '\n');
            String sep = String.valueOf(this.separator);
            for (String subData : data) {
                if (subData.contains(sep)) {
                    if (subData.endsWith(sep) || subData.endsWith(sep.concat("\r"))) {
                        sb.append(subData).append('\n');
                        continue;
                    }
                    if (subData.endsWith(String.valueOf('\r'))) {
                        int len = subData.length();
                        sb.append(subData, 0, len - 1).append(this.separator).append(LINE_SEPARATOR);
                        this.setCharOffset(1);
                        continue;
                    }
                    sb.append(subData).append(this.separator).append(LINE_SEPARATOR);
                    this.setCharOffset(2);
                    continue;
                }
                if (subData != null && subData.length() > 0 && subData.charAt(subData.length() - 1) == '\t') {
                    sb.append(subData);
                    continue;
                }
                sb.append(subData).append('\n');
            }
        } else {
            String[] data = FileEnhanceKDProcessor.split(content, this.separator);
            for (int i = 0; i < data.length; ++i) {
                if ((i + 1) % this.recordNum == 0 && i != data.length - 1) {
                    if (data[i].endsWith("\n")) continue;
                    sb.append(data[i]).append(this.separator).append(LINE_SEPARATOR);
                    this.setCharOffset(LINE_SEPARATOR.length());
                    data[i] = sb.toString();
                    continue;
                }
                sb.append(data[i]).append(this.separator);
            }
        }
        return sb.toString();
    }

    public static String[] split(String s, char c) {
        if (s == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char d = s.charAt(i);
            if (d != c) {
                sb.append(d);
                continue;
            }
            list.add(sb.toString());
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean isSkipFirstLine() {
        return this.skipFirstLine;
    }

    public void setSkipFirstLine(boolean skipFirstLine) {
        this.skipFirstLine = skipFirstLine;
    }

    public void setRecordNum(int recordNum) {
        this.recordNum = recordNum;
    }

    public int getCharOffset() {
        return this.charOffset;
    }

    public void setCharOffset(int charOffset) {
        this.charOffset = charOffset;
    }

    @Override
    public int getPaymentSize() {
        return this.paymentSize;
    }

    @Override
    public void setPaymentSize(int paymentSize) {
        this.paymentSize = paymentSize;
    }
}

