/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.reconciliation.processor;

import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.common.framework.reconciliation.AbstractKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.KDProcessorEnum;
import kd.ebg.aqap.common.framework.reconciliation.find.FindNodeInfo;
import kd.ebg.aqap.common.framework.reconciliation.processor.FileEnhanceKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.processor.XmlKDProcessor;
import kd.ebg.egf.common.utils.string.StringUtils;

public class XMLDataDomainKDProcessor
extends AbstractKDProcessor {
    private int recordNum;
    private boolean skipFirstLine;

    public XMLDataDomainKDProcessor(int recordNum, boolean skipFirstLine) {
        this.recordNum = recordNum;
        this.skipFirstLine = skipFirstLine;
    }

    @Override
    public List<FindNodeInfo> handle(String content, String nodePath) {
        ArrayList<FindNodeInfo> XDDNodeInfoList = new ArrayList<FindNodeInfo>(16);
        if (this.recordNum == 0) {
            this.logger.warn("\u6570\u636e\u57df\u6bcf\u6761\u8bb0\u5f55\u7684\u5b57\u6bb5\u6570\u914d\u7f6e\u4e3a0\u3002");
            return XDDNodeInfoList;
        }
        List<FindNodeInfo> nodeInfoList = this.doXmlProcess(content, this.getNodePath(true, nodePath));
        String dataDomainPath = this.getNodePath(false, nodePath);
        for (FindNodeInfo nodeInfo : nodeInfoList) {
            String dataDomain = nodeInfo.getNodeValue();
            List<FindNodeInfo> fileNodeInfoList = this.doFileProcess(dataDomain, dataDomainPath);
            for (FindNodeInfo fileNodeInfo : fileNodeInfoList) {
                FindNodeInfo xddNodeInfo = this.getXDDNodeInfo(nodeInfo, fileNodeInfo);
                if (xddNodeInfo == null) continue;
                XDDNodeInfoList.add(xddNodeInfo);
            }
        }
        return XDDNodeInfoList;
    }

    private FindNodeInfo getXDDNodeInfo(FindNodeInfo parentNodeInfo, FindNodeInfo fileNodeInfo) {
        int i;
        FindNodeInfo xddNodeInfo = null;
        String value = fileNodeInfo.getNodeValue();
        int upOffset = 0;
        int downOffset = 0;
        boolean emptyFlag = true;
        for (i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '\t') {
                ++upOffset;
                continue;
            }
            emptyFlag = false;
            break;
        }
        if (!emptyFlag) {
            for (i = value.length() - 1; i >= 0 && value.charAt(i) == '\t'; --i) {
                ++downOffset;
            }
            String nodeValue = value.substring(upOffset, value.length() - downOffset);
            if (StringUtils.isNotEmpty((String)nodeValue)) {
                xddNodeInfo = new FindNodeInfo();
                xddNodeInfo.setNodeName(fileNodeInfo.getNodeName());
                xddNodeInfo.setNodeValue(nodeValue);
                xddNodeInfo.setStartIndex(parentNodeInfo.getStartIndex() + fileNodeInfo.getStartIndex() + upOffset);
                xddNodeInfo.setEndIndex(parentNodeInfo.getStartIndex() + fileNodeInfo.getEndIndex() - downOffset);
            }
        }
        return xddNodeInfo;
    }

    private String getNodePath(boolean isXml, String originalPath) {
        String _XDD_ = KDProcessorEnum.XML_DATA_DOMAIN_KD_PROCESSOR.getSeparator();
        int index = originalPath.indexOf(_XDD_);
        if (index > -1) {
            if (isXml) {
                return originalPath.substring(0, index);
            }
            return originalPath.substring(index += _XDD_.length());
        }
        return originalPath;
    }

    private List<FindNodeInfo> doXmlProcess(String content, String nodePath) {
        return new XmlKDProcessor().handle(content, nodePath);
    }

    private List<FindNodeInfo> doFileProcess(String content, String nodePath) {
        FileEnhanceKDProcessor fileKDProcessor = new FileEnhanceKDProcessor();
        fileKDProcessor.setRecordNum(this.recordNum);
        fileKDProcessor.setSkipFirstLine(this.skipFirstLine);
        fileKDProcessor.setPaymentSize(this.getPaymentSize());
        return fileKDProcessor.handle(content, nodePath);
    }
}

