/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.aqap.common.model.repository.FinancingRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;

@Service
public class FinancingService {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(FinancingService.class);
    private FinancingRepository financingRepository;

    public FinancingService(FinancingRepository financingRepository) {
        this.financingRepository = financingRepository;
    }

    public static FinancingService getInstance() {
        return SpringContextUtil.getBean(FinancingService.class);
    }

    public void insertAll(List<FinancingInfo> infos) {
        this.financingRepository.save(infos);
    }

    public List<FinancingInfo> save(List<FinancingInfo> infos) {
        return this.financingRepository.save(infos);
    }

    public List<FinancingInfo> selectByCreateTimeBeforeAndStatus(LocalDateTime time, int statusId) {
        String currentNode = SpringContextUtil.getBean(SingleNodeIDGetter.class).nodeID();
        return this.financingRepository.findByCreateTimeBeforeAndStatusAndEbgId(time, statusId, currentNode);
    }

    public List<FinancingInfo> selectByBatchSeqID(String batchSeqId) {
        return this.financingRepository.findByBatchSeqID(batchSeqId);
    }

    public boolean batchSeqIDExist(String batchSeqID) {
        return this.financingRepository.existsByBatchSeqID(batchSeqID);
    }

    public boolean existsByDetailBizNo(String detailBizNo) {
        return this.financingRepository.existsByDetailBizNoAndBackBankStatus(detailBizNo, "1");
    }

    public List<FinancingInfo> compareAndStateState(List<FinancingInfo> infos, FinancingState expect, FinancingState state) {
        for (FinancingInfo info : infos) {
            if (info.getStatus().intValue() != expect.getId()) {
                logger.info("\u7406\u8d22 :{} \u7684\u72b6\u6001:{} \u4e0e\u9884\u671f\u7684\u72b6\u6001: {}\u4e0d\u4e00\u81f4", new Object[]{info.getId(), info.getStatus(), expect.getId()});
                return null;
            }
            info.setStatus(state.getId());
            info.setStatusMsg(state.getCnName());
            info.setStatusName(state.getEnName());
            info.setSubmitSuccessTime(LocalDateTime.now());
        }
        try {
            return this.financingRepository.save(infos);
        }
        catch (Exception e) {
            String batchSeqId = infos.get(0).getBatchSeqId();
            logger.info("\u94f6\u884c\u6279\u6b21\u53f7\u4e3a:{}", (Object)batchSeqId);
            logger.info("\u5c1d\u8bd5\u4fee\u6539\u72b6\u6001\u5931\u8d25", (Object)e);
            return null;
        }
    }

    public boolean updateInvalidNodesFromSubmittingToUnknown(List<String> nonExistences) {
        String currentNode = SpringContextUtil.getBean(SingleNodeIDGetter.class).nodeID();
        for (String node : nonExistences) {
            List<FinancingInfo> submittingInfos = this.financingRepository.findByStatusAndEbgId(FinancingState.SUBMITTING.getId(), node);
            Optional.ofNullable(submittingInfos).ifPresent(infos -> {
                infos.forEach(info -> {
                    info.setStatus(PaymentState.UNKNOWN.getId());
                    info.setStatusName(PaymentState.UNKNOWN.getEnName());
                    info.setStatusMsg(PaymentState.UNKNOWN.getCnName());
                    info.setEbSeqId(currentNode);
                });
                this.financingRepository.save((List<FinancingInfo>)infos);
            });
            logger.info("\u68c0\u67e5\u5386\u53f2\u8282\u70b9{}\u72b6\u6001\u4e3a\u201c\u63d0\u4ea4\u4e2dSUBMITTING\u201d\u7684\u7406\u8d22\u6570\u636e\uff0c\u5c1d\u8bd5\u4fee\u6539\u4e3a\u5f53\u524d\u8282\u70b9{}\u201c\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\u201d\uff0c\u5df2\u627e\u5230{}\u6761", new Object[]{node, currentNode, submittingInfos.size()});
        }
        List<FinancingInfo> submittingInfos = this.financingRepository.findByStatusAndEbgId(PaymentState.SUBMITTING.getId(), currentNode);
        Optional.ofNullable(submittingInfos).ifPresent(paymentInfos -> {
            paymentInfos.forEach(info -> {
                info.setStatus(PaymentState.UNKNOWN.getId());
                info.setStatusName(PaymentState.UNKNOWN.getEnName());
                info.setStatusMsg(PaymentState.UNKNOWN.getCnName());
            });
            this.financingRepository.save((List<FinancingInfo>)paymentInfos);
        });
        logger.info("\u68c0\u67e5\u5f53\u524d\u8282\u70b9{}\u72b6\u6001\u4e3a\u201c\u63d0\u4ea4\u4e2dSUBMITTING\u201d\u7684\u7406\u8d22\u6570\u636e\uff0c\u5c1d\u8bd5\u4fee\u6539\u4e3a\u201c\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\u201d\uff0c\u5df2\u627e\u5230{}\u6761", new Object[]{currentNode, submittingInfos.size()});
        return true;
    }

    public List<FinancingInfo> findByStatusAndUpdateTimeLessThanAndInsertTimeAfterAndEbgIdNot(int status, LocalDateTime dateTime) {
        String nodeId = SpringContextUtil.getBean(SingleNodeIDGetter.class).nodeID();
        return this.financingRepository.findByStatusAndUpdateTimeLessThanAndInsertTimeAfterAndEbgIdNot(status, dateTime, LocalDateTime.now().minusDays(7L), nodeId);
    }

    public List<FinancingInfo> selectByStatusAndOwnIsMe(int statusStart, int statusEnd, LocalDateTime date, int limitNum) {
        String nodeId = SpringContextUtil.getBean(SingleNodeIDGetter.class).nodeID();
        return this.financingRepository.findByStatusBetweenAndUpdateTimeLessThanAndEbgIDAndSyncCountLessThanOrderByUpdateTimeAsc(statusStart, statusEnd, date, nodeId, limitNum);
    }

    public List<FinancingInfo> selectByStatusAndOwnIsNotMe(int statusStart, int statusEnd, LocalDateTime date, int limitNum) {
        String nodeId = SpringContextUtil.getBean(SingleNodeIDGetter.class).nodeID();
        return this.financingRepository.findByStatusBetweenAndUpdateTimeLessThanAndEbgIDNotAndSyncCountLessThan(statusStart, statusEnd, date, nodeId, limitNum);
    }

    public List<FinancingInfo> modifyOwnToMe(List<FinancingInfo> infos) {
        String nodeId = SpringContextUtil.getBean(SingleNodeIDGetter.class).nodeID();
        logger.info("\u4fee\u6539\u7406\u8d22\u8282\u70b9\uff0c\u5f53\u524d\u8282\u70b9\u4e3a\uff1a" + nodeId);
        infos.forEach(info -> {
            info.setEbgId(nodeId);
            info.setUpdateTime(LocalDateTime.now());
        });
        return this.save(infos);
    }

    public List<FinancingInfo> selectByBatchSeqIDAndDetailSeqID(String batchSeqID, String detailSeqID) {
        return this.financingRepository.findByBatchSeqIDAndDetailSeqID(batchSeqID, detailSeqID);
    }
}

