/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.utils;

import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.service.currency.BankCurrencyService;
import kd.ebg.egf.common.framework.service.currency.IsoCurrencyService;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;

public class CurrencyUtils {
    public static String convert2Bank(String isoCode) {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        String customID = EBContext.getContext().getCustomID();
        return CurrencyUtils.convert2Bank(isoCode, bankVersionID, customID);
    }

    public static String convert2Bank(String isoCode, String bankVersionID, String customID) {
        IsoCurrencyService.getInstance().checkIsoCurrency(isoCode);
        return BankCurrencyService.getInstance().getBankCurrency(bankVersionID, isoCode, customID);
    }

    public static String checkAndGetISOCurrency(String currency, String customID, String bankVersionID) {
        if (StringUtils.isEmpty((String)currency)) {
            return "";
        }
        if (StringUtils.isNotEmpty((String)customID) && StringUtils.isNotEmpty((String)bankVersionID)) {
            if (CurrencyUtils.isISOCurrency(currency)) {
                return currency;
            }
            return CurrencyUtils.convert2Iso(currency, customID, bankVersionID);
        }
        return currency;
    }

    @SdkDeprecated
    public static String convert2Iso(String bankCurrency) {
        if (EBContext.getContext() != null) {
            String bankVersionID = EBContext.getContext().getBankVersionID();
            String customID = EBContext.getContext().getCustomID();
            return CurrencyUtils.convert2Iso(bankCurrency, bankVersionID, customID);
        }
        return bankCurrency;
    }

    public static String convert2Iso(String bankCurrency, String bankVersionID, String customID) {
        return BankCurrencyService.getInstance().getIsoCurrency(bankVersionID, bankCurrency, customID);
    }

    public static String getCurrencyName(String bankCurrency) {
        String isoCurrency = CurrencyUtils.convert2Iso(bankCurrency);
        return IsoCurrencyService.getInstance().getCurrencyName(isoCurrency);
    }

    public static void checkIsoCurrency(String isoCurrency) {
        IsoCurrencyService.getInstance().checkCurrencyName(isoCurrency);
    }

    public static boolean isISOCurrency(String currency) {
        QFilter filter = QFilter.of((String)"number=? and enable='1'", (Object[])new Object[]{currency});
        Map map = BusinessDataServiceHelper.loadFromCache((String)"aqap_iso_currency", (String)"number", (QFilter[])filter.toArray());
        return map.size() == 1;
    }
}

