/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ebg.aqap.common.model.BalanceReconciliationRecord;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class BalanceReconciliationRecordRepository {
    private String ENTITY_NAME = "aqap_balance_rec_record";
    private static String SELECT_PROPERTIES = "id,acc_no,currency,sync_date,custom_id,enable,sync_count,createtime,modifytime";

    public void saveAll(List<BalanceReconciliationRecord> details) {
        if (CollectionUtils.isNotEmpty(details)) {
            DynamicObject[] dynamicObjects = new DynamicObject[details.size()];
            for (int i = 0; i < details.size(); ++i) {
                dynamicObjects[i] = this.transDynamicObject(null, details.get(i));
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public void saveOrUpdateAll(List<BalanceReconciliationRecord> insertDetails, List<BalanceReconciliationRecord> updateDetails) {
        int i;
        DynamicObject[] dynamicObjects;
        if (CollectionUtils.isNotEmpty(insertDetails)) {
            dynamicObjects = new DynamicObject[insertDetails.size()];
            for (i = 0; i < insertDetails.size(); ++i) {
                dynamicObjects[i] = this.transDynamicObject(null, insertDetails.get(i));
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        if (CollectionUtils.isNotEmpty(updateDetails)) {
            dynamicObjects = new DynamicObject[updateDetails.size()];
            for (i = 0; i < updateDetails.size(); ++i) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)updateDetails.get(i).getId(), (String)this.ENTITY_NAME);
                dynamicObjects[i] = this.transDynamicObject(dynamicObject, updateDetails.get(i));
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public List<BalanceReconciliationRecord> findByAccNoAndCurrencyAndMonthBetween(String accNo, String currency, LocalDate startDate, LocalDate endDate) {
        ArrayList<BalanceReconciliationRecord> records = new ArrayList<BalanceReconciliationRecord>(1);
        QFilter filter = QFilter.of((String)"acc_no=? and currency=? and sync_date>=? and sync_date<=?", (Object[])new Object[]{accNo, currency, startDate, endDate});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                records.add(this.transBalanceReconciliationRecord((DynamicObject)dynamicObjects.get(i)));
            }
        }
        return records;
    }

    private DynamicObject transDynamicObject(DynamicObject dynamicObject, BalanceReconciliationRecord record) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_NAME);
        }
        if (StringUtils.isNotEmpty((String)record.getId())) {
            this.setDynamicParamater(dynamicObject, "id", record.getId());
        }
        this.setDynamicParamater(dynamicObject, "acc_no", record.getAccNo());
        this.setDynamicParamater(dynamicObject, "custom_id", record.getCustomID());
        this.setDynamicParamater(dynamicObject, "enable", record.getEnable());
        this.setDynamicParamater(dynamicObject, "sync_count", record.getSyncCount());
        this.setDynamicParamater(dynamicObject, "currency", record.getCurrency());
        if (record.getInsertTime() == null) {
            Date insertTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            this.setDynamicParamater(dynamicObject, "createtime", insertTime);
        } else {
            this.setDynamicParamater(dynamicObject, "createtime", LocalDateUtil.localDateTime2Date((LocalDateTime)record.getInsertTime()));
        }
        this.setDynamicParamater(dynamicObject, "modifytime", Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        dynamicObject.set("sync_date", (Object)LocalDateUtil.localDate2Date((LocalDate)record.getSyncDate()));
        return dynamicObject;
    }

    public void setDynamicParamater(DynamicObject dynamicObject, String key, Object value) {
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)((String)value))) {
                value = " ";
            }
        } else if (value instanceof Integer && value == null) {
            value = 0;
        }
        dynamicObject.set(key, value);
    }

    private BalanceReconciliationRecord transBalanceReconciliationRecord(DynamicObject dynamicObject) {
        BalanceReconciliationRecord result = new BalanceReconciliationRecord();
        result.setId(dynamicObject.getString("id"));
        result.setAccNo(dynamicObject.getString("acc_no"));
        result.setCustomID(dynamicObject.getString("custom_id"));
        LocalDateTime insertTime = DTFactoryUtil.parseDateTime((String)dynamicObject.getString("createtime"));
        result.setInsertTime(insertTime);
        LocalDateTime updateTime = DTFactoryUtil.parseDateTime((String)dynamicObject.getString("modifytime"));
        result.setUpdateTime(updateTime);
        LocalDate syncDate = LocalDateUtil.date2LocalDate((Date)dynamicObject.getDate("sync_date"));
        result.setSyncDate(syncDate);
        result.setEnable(dynamicObject.getInt("enable"));
        result.setSyncCount(dynamicObject.getInt("sync_count"));
        result.setCurrency(dynamicObject.getString("currency"));
        return result;
    }
}

