/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.BankFile;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.utils.DTFactoryUtil;

@Component
public class BankFileRepository {
    private static final String SELECT_ALL_PROPERTIES = "id,custom_id,bank_version,acc_no,file_type,file_name,file_content_tag,trans_date,createtime";

    public void save(BankFile bankFile) {
        DynamicObject dynamicObject = this.packBankFileInfo(null, bankFile);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public BankFile findById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_bank_file", (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            return this.transBankFileInfo(dynamicObject);
        }
        return null;
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)"aqap_bank_file", (QFilter[])filter.toArray());
        }
    }

    public void deleteLessThanCreateTime(String customId, LocalDateTime createTime) {
        QFilter filter = QFilter.of((String)"custom_id = ? and createtime <= ?", (Object[])new Object[]{customId, createTime});
        DeleteServiceHelper.delete((String)"aqap_bank_file", (QFilter[])filter.toArray());
    }

    public void deleteOneMonthAgo(String customId) {
        this.deleteLessThanCreateTime(customId, LocalDateTime.now().minusDays(30L));
    }

    private BankFile transBankFileInfo(DynamicObject dynamicObject) {
        BankFile bankFile = new BankFile();
        bankFile.setId(dynamicObject.getLong("id"));
        bankFile.setCustomID(dynamicObject.getString("custom_id"));
        bankFile.setBankVersionId(dynamicObject.getString("bank_version.number"));
        bankFile.setAccNo(dynamicObject.getString("acc_no"));
        bankFile.setFileName(dynamicObject.getString("file_name"));
        bankFile.setFileContent(dynamicObject.getString("file_content_tag"));
        bankFile.setFileType(dynamicObject.getString("file_type"));
        bankFile.setTransDate(DTFactoryUtil.parseDate((String)dynamicObject.getString("trans_date")));
        bankFile.setCreateTime(DTFactoryUtil.parseDateTime((String)dynamicObject.getString("createtime")));
        return bankFile;
    }

    private DynamicObject packBankFileInfo(DynamicObject dynamicObject, BankFile bankFile) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"aqap_bank_file");
        } else {
            dynamicObject.set("id", (Object)bankFile.getId());
        }
        dynamicObject.set("custom_id", (Object)bankFile.getCustomID());
        BankVersionRepository bankVersionRepository = SpringContextUtil.getBean(BankVersionRepository.class);
        DynamicObject bankVersion = bankVersionRepository.loadDynamicObjectByBankVersionID(bankFile.getBankVersionId());
        dynamicObject.set("bank_version", (Object)bankVersion);
        dynamicObject.set("acc_no", (Object)bankFile.getAccNo());
        dynamicObject.set("file_type", (Object)bankFile.getFileType());
        dynamicObject.set("file_content_tag", (Object)bankFile.getFileContent());
        dynamicObject.set("file_name", (Object)bankFile.getFileName());
        Date transDate = Date.from(bankFile.getTransDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("trans_date", (Object)transDate);
        Date insertTime = Date.from(bankFile.getCreateTime().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("createtime", (Object)insertTime);
        return dynamicObject;
    }
}

