/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingBankField;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingProductDetail;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class BdBusinessRespository {
    private String ENTITY = "aqap_bd_business";
    private String SELECT_PROPERTIES = "id,billno,bank_version_id,attr_key,attr_value,attr_name,business_type,business_detail,custom_id,modifytime";

    public Map<String, List<FinancingBankField>> findFinancingByProductCodeInAndBankVersionID(List<String> productCodes, String bankVersionID) {
        HashMap<String, List<FinancingBankField>> group = new HashMap<String, List<FinancingBankField>>(16);
        QFilter[] filters = new QFilter[]{new QFilter("billno", "in", productCodes), QFilter.of((String)"bank_version_id=? and business_type=? and business_detail=?", (Object[])new Object[]{bankVersionID, "FINANCING", "FINANCING_DETAIL"})};
        DynamicObjectCollection dynamicObjectCollections = QueryServiceHelper.query((String)this.ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filters);
        if (CollectionUtil.isNotEmpty((Collection)dynamicObjectCollections)) {
            for (DynamicObject dynamicObject : dynamicObjectCollections) {
                String productCode = dynamicObject.getString("billno");
                if (group.get(productCode) == null) {
                    ArrayList<FinancingBankField> bankFields = new ArrayList<FinancingBankField>(16);
                    bankFields.add(this.transFinancingBankField(dynamicObject));
                    group.put(productCode, bankFields);
                    continue;
                }
                ((List)group.get(productCode)).add(this.transFinancingBankField(dynamicObject));
            }
        }
        return group;
    }

    public void insertOrUpdate(FinancingProductDetail detail) {
        if (CollectionUtil.isNotEmpty(detail.getBankFields())) {
            ArrayList<String> keys = new ArrayList<String>(16);
            HashMap<String, FinancingBankField> map = new HashMap<String, FinancingBankField>(16);
            List<FinancingBankField> addList = detail.getBankFields();
            for (FinancingBankField financingBankField : addList) {
                keys.add(financingBankField.getKey());
                map.put(financingBankField.getKey(), financingBankField);
            }
            QFilter[] qFilters = new QFilter[]{QFilter.of((String)"bank_version_id=? and billno=? and business_type=? and business_detail=?", (Object[])new Object[]{detail.getBankVersionID(), detail.getProductCode(), "FINANCING", "FINANCING_DETAIL"}), new QFilter("attr_key", "in", keys)};
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)this.ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])qFilters);
            if (objects != null && objects.length > 0) {
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
                for (int i = 0; i < objects.length; ++i) {
                    FinancingBankField financingBankField = (FinancingBankField)map.get(objects[i].getString("attr_key"));
                    if (financingBankField == null) continue;
                    updateList.add(this.packFinancingBusinessInfo(objects[i], financingBankField, detail.getProductCode(), detail.getBankVersionID()));
                    addList.remove(financingBankField);
                }
                if (CollectionUtil.isNotEmpty(updateList)) {
                    SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
                }
            }
            this.insertAllBankFiles(addList, detail.getProductCode(), detail.getBankVersionID());
        }
    }

    public void deleteFinancingBusinessByBankVersionIDAndProductCode(String bankVersionID, String productCode) {
        DeleteServiceHelper.delete((String)this.ENTITY, (QFilter[])QFilter.of((String)"bank_version_id=? and billno=? and business_type=? and business_detail=?", (Object[])new Object[]{bankVersionID, productCode, "FINANCING", "FINANCING_DETAIL"}).toArray());
    }

    public void deleteFinancingBusinessByBankVersionID(String bankVersionID) {
        DeleteServiceHelper.delete((String)this.ENTITY, (QFilter[])QFilter.of((String)"bank_version_id=? and business_type=? and business_detail=?", (Object[])new Object[]{bankVersionID, "FINANCING", "FINANCING_DETAIL"}).toArray());
    }

    public void insertAllBankFiles(List<FinancingBankField> financingBankFields, String productCode, String bankVersionID) {
        if (CollectionUtil.isNotEmpty(financingBankFields)) {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(16);
            for (FinancingBankField financingBankField : financingBankFields) {
                dynamicObjectList.add(this.packFinancingBusinessInfo(null, financingBankField, productCode, bankVersionID));
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
        }
    }

    public void insertAll(List<FinancingProductDetail> detailInfos) {
        if (detailInfos != null && detailInfos.size() > 0) {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(16);
            for (FinancingProductDetail detail : detailInfos) {
                if (!CollectionUtils.isEmpty(detail.getBankFields())) {
                    for (FinancingBankField financingBankField : detail.getBankFields()) {
                        dynamicObjectList.add(this.packFinancingBusinessInfo(null, financingBankField, detail.getProductCode(), detail.getBankVersionID()));
                    }
                }
                if (dynamicObjectList.size() < 10000) continue;
                SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
                dynamicObjectList.clear();
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
        }
    }

    private FinancingBankField transFinancingBankField(DynamicObject dynamicObject) {
        FinancingBankField financingBankField = new FinancingBankField();
        financingBankField.setKey(dynamicObject.getString("attr_key"));
        financingBankField.setValue(dynamicObject.getString("attr_value"));
        financingBankField.setName(dynamicObject.getString("attr_name"));
        return financingBankField;
    }

    private DynamicObject packFinancingBusinessInfo(DynamicObject dynamicObject, FinancingBankField bankField, String productCode, String bankVersionID) {
        Date date = new Date();
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY);
            dynamicObject.set("createtime", (Object)date);
        }
        dynamicObject.set("billno", (Object)StringUtils.trim((String)productCode));
        dynamicObject.set("bank_version_id", (Object)bankVersionID);
        dynamicObject.set("attr_key", (Object)bankField.getKey());
        dynamicObject.set("attr_value", (Object)StringUtils.trim((String)bankField.getValue()));
        dynamicObject.set("attr_name", (Object)StringUtils.trim((String)bankField.getName()));
        dynamicObject.set("business_type", (Object)"FINANCING");
        dynamicObject.set("business_detail", (Object)"FINANCING_DETAIL");
        dynamicObject.set("modifytime", (Object)date);
        return dynamicObject;
    }
}

