/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.aqap.common.model.transform.OpenCreditTransFormer;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

@Component
public class OpenCreditRepository {
    EBGLogger log = EBGLogger.getInstance().getLogger(OpenCreditRepository.class);
    private final String PAYABLE_ENTITY = "aqap_open_credit";
    private final String SELECT_ALL_PROPERTIES = "detailseqid,detailbizno,applicantcreditnum,creditno,currency,amount,contractno,contractamount,credittype,creditmode,creditform,opendate,moreproportion,lessproportion,duedate,dueaddress,applicantaddressen,counteraddress,mrgnproportion,mrgnacctype,mrgnaccno,mrgncurrency,characcno,charcurrency,costbear,oprnm,oprtel,advicnapscode,adviaddress,forwardcnapscode,forwardaddress,avwtbank,avwtbankbic,avwtbanknmadd,draftcustflg,paytype,paydays,acceptorcnapscode,acceptoraddress,cashway,draftproportion,draftamt,mixdraftinvproportion,mixdraftinvamt,mixtenortype,mixtenordays,explain,draweecnapscode,draweeaddress,ispartship,istranship,shipdate,presentperiod,presentday,deliveryport,startair,terminiair,termini,gasdescription,docclause,addclause,remark,bankrefdate,bankrefkey,fileurl,filename,reserved1,reserved2,creditstatus,id,ebgid,version,customid,bankversionid,bankloginid,biztype,subbiztype,implclassname,queryimplclassname,packagekey,updatetime,inserttime,status,statusname,statusmsg,bankstatus,bankmsg,packagetime,bankbatchseqid,bankdetailseqid,bankserialno,submitsuccesstime,lastsynctime,synccount,payfinishtime,flowserialno,rqstserialno,requesttime,batchseqid,accno,errormsg,coninstructions,addclause_tag,docclause_tag,acptdate,receivedno,busamt,costbearparty,feemode,docpcsmode,buscurrency,payaccno,payacccurrency,payamt,payeecountry,paynature,ibpisref,ibppaytype,trancode,corramt,txnpscpt,ibpregno,returndesc_tag,refusepoint,charfeeinfo_tag,,payaccno2,payacccurrency2,payamt2,applicantname,countername,countercountry,transflag,contractcurrency,afterfrom,docs,reject,drawon,lastshipdate,mixtenor,receiptplace,charges,addamt,reduceamt,modfrequency,lastmoddate";

    public List<OpenCreditDetail> findByBatchSeqId(String batchSeqId) {
        QFilter filter = QFilter.of((String)"batchseqid = ?", (Object[])new Object[]{batchSeqId});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_open_credit", (String)"detailseqid,detailbizno,applicantcreditnum,creditno,currency,amount,contractno,contractamount,credittype,creditmode,creditform,opendate,moreproportion,lessproportion,duedate,dueaddress,applicantaddressen,counteraddress,mrgnproportion,mrgnacctype,mrgnaccno,mrgncurrency,characcno,charcurrency,costbear,oprnm,oprtel,advicnapscode,adviaddress,forwardcnapscode,forwardaddress,avwtbank,avwtbankbic,avwtbanknmadd,draftcustflg,paytype,paydays,acceptorcnapscode,acceptoraddress,cashway,draftproportion,draftamt,mixdraftinvproportion,mixdraftinvamt,mixtenortype,mixtenordays,explain,draweecnapscode,draweeaddress,ispartship,istranship,shipdate,presentperiod,presentday,deliveryport,startair,terminiair,termini,gasdescription,docclause,addclause,remark,bankrefdate,bankrefkey,fileurl,filename,reserved1,reserved2,creditstatus,id,ebgid,version,customid,bankversionid,bankloginid,biztype,subbiztype,implclassname,queryimplclassname,packagekey,updatetime,inserttime,status,statusname,statusmsg,bankstatus,bankmsg,packagetime,bankbatchseqid,bankdetailseqid,bankserialno,submitsuccesstime,lastsynctime,synccount,payfinishtime,flowserialno,rqstserialno,requesttime,batchseqid,accno,errormsg,coninstructions,addclause_tag,docclause_tag,acptdate,receivedno,busamt,costbearparty,feemode,docpcsmode,buscurrency,payaccno,payacccurrency,payamt,payeecountry,paynature,ibpisref,ibppaytype,trancode,corramt,txnpscpt,ibpregno,returndesc_tag,refusepoint,charfeeinfo_tag,,payaccno2,payacccurrency2,payamt2,applicantname,countername,countercountry,transflag,contractcurrency,afterfrom,docs,reject,drawon,lastshipdate,mixtenor,receiptplace,charges,addamt,reduceamt,modfrequency,lastmoddate", (QFilter[])filter.toArray());
        ArrayList<OpenCreditDetail> paymentInfos = new ArrayList<OpenCreditDetail>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            paymentInfos.add(OpenCreditTransFormer.getInstance().packNotePayable(dynamicObject));
        }
        return paymentInfos;
    }

    public long countByBatchSeqId(String batchSeqId) {
        QFilter filter = QFilter.of((String)"batchseqid = ?", (Object[])new Object[]{batchSeqId});
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"aqap_open_credit", (String)"id", (QFilter[])filter.toArray(), (String)"");){
            long total;
            long l = total = (long)ds.count("id", false);
            return l;
        }
    }

    public long countDetailBizId(String batchSeqId) {
        QFilter filter = QFilter.of((String)"detailbizno = ?", (Object[])new Object[]{batchSeqId});
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"aqap_open_credit", (String)"id", (QFilter[])filter.toArray(), (String)"");){
            long total;
            long l = total = (long)ds.count("id", false);
            return l;
        }
    }

    public List<OpenCreditDetail> save(List<OpenCreditDetail> openCreditDetails) {
        ArrayList<OpenCreditDetail> insertList = new ArrayList<OpenCreditDetail>();
        ArrayList<OpenCreditDetail> updateList = new ArrayList<OpenCreditDetail>();
        for (OpenCreditDetail info : openCreditDetails) {
            Long id = info.getId();
            if (QueryServiceHelper.exists((String)"aqap_open_credit", (Object)id)) {
                updateList.add(info);
                continue;
            }
            insertList.add(info);
        }
        this.insertAll(insertList);
        this.updateAll(updateList);
        return openCreditDetails;
    }

    public void insertAll(List<OpenCreditDetail> Infos) {
        if (Infos.size() > 0) {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(Infos.size());
            for (OpenCreditDetail into : Infos) {
                dynamicObjectList.add(OpenCreditTransFormer.getInstance().transNotePayable(into));
            }
            DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[Infos.size()]);
            this.log.info("\u5f85\u63d2\u5165\u8bb0\u5f55\uff1a{}\u6761", (Object)Infos.size());
            try {
                Object[] objs = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                for (int i = 0; i < objs.length; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)objs[i];
                    Infos.get(i).setId(dynamicObject.getLong("id"));
                }
                this.log.info("\u8bb0\u5f55\u63d2\u5165\u5b8c\u6210");
            }
            catch (Exception e) {
                this.log.error("\u8bb0\u5f55\u63d2\u5165\u5931\u8d25");
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
    }

    public synchronized void updateAll(List<OpenCreditDetail> openCreditDetails) {
        if (openCreditDetails.size() > 0) {
            try {
                ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(openCreditDetails.size());
                for (OpenCreditDetail info : openCreditDetails) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"aqap_open_credit");
                    dynamicObjectList.add(OpenCreditTransFormer.getInstance().transNotePayable(dynamicObject, info));
                }
                DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[openCreditDetails.size()]);
                this.log.info("\u5f85\u66f4\u65b0\u8bb0\u5f55\uff1a{}\u6761", (Object)openCreditDetails.size());
                OpenCreditTransFormer.getInstance().updateWithVersion(dynamicObjects, openCreditDetails);
                this.log.info("\u8bb0\u5f55\u66f4\u65b0\u5b8c\u6210");
            }
            catch (Exception e) {
                this.log.error("\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25\uff1a", (Throwable)e);
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
    }
}

