/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.services.Check;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class NoticeDepositBalanceParser {
    public static EBBankBalanceResponse parseNoticeDepositBalance(BankBalanceRequest rqst, String rspStr) {
        String balance;
        BankResponse rsp = ParserRsp.parseRsp(rspStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        Element lists = Check.checkNoNullChildElement(body, "lists");
        String amount = body.getChildText("amount");
        HashMap<String, String> balanceMap = new HashMap<String, String>(16);
        List localList = lists.getChildren("list");
        int length = localList.size();
        for (int i = 0; i < length; ++i) {
            Element e = (Element)localList.get(i);
            balance = e.getChildText("balance");
            String noticeAcctNo = e.getChildText("noticeAcctNo");
            balanceMap.put(noticeAcctNo, balance);
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        String accNo = rqst.getAcnt().getAccNo();
        balance = (String)balanceMap.get(accNo);
        if (!balance.isEmpty()) {
            BankAcnt acnt = new BankAcnt();
            acnt.setAccNo(accNo);
            balanceInfo.setBankAcnt(acnt);
            balanceInfo.setBankCurrency(rqst.getBankCurrency());
            BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)amount);
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8be5\u8d26\u53f7\u4f59\u989d\u3002", (String)"NoticeDepositBalanceParser_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
    }
}

